/* $Id: val2sec.c,v 1.1 1999/11/15 23:34:57 hender Exp $ */

/*
 *  Convert a value string from time to its equivalent value in seconds.
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pbs_ifl.h"
#include "log.h"

#include "toolkit.h"

time_t 
schd_val2sec(char *val)
{
    char   *id = "val2sec";
    char   *p1, *p2, *p3, *end, *zero = "0";
    time_t  v1, v2, v3;
    time_t  sec;
    char   *valcopy;

    p3 = NULL;

    valcopy = schd_strdup(val);
    if (valcopy == NULL) {
	(void)sprintf(log_buffer, "schd_strdup(val) failed.");
	log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	DBPRT(("%s: %s\n", id, log_buffer));
	return ((time_t) -1);
    }

    /* Split string into at most 3 tokens. */
    p1 = strtok(valcopy, ":");
    p2 = strtok(NULL, ":");
    if (p2 != NULL) {
	p3 = strtok(NULL, ":");
    }

    /* Only seconds specified.  Shift right 2 places into p3, and zero fill */
    if (p2 == NULL) {
	p3 = p1;
	p2 = zero;
	p1 = zero;
    }

    /* Minutes and seconds specified.  Shift right into p3, and zero fill */
    if (p3 == NULL) {
	p3 = p2;
	p2 = p1;
	p1 = zero;
    }

    v1 = (time_t)strtol(p1, &end, 10);
    if (*end != '\0')
	goto error;
    if (v1 < 0)
	goto error;

    v2 = (time_t)strtol(p2, &end, 10);
    if (*end != '\0')
	goto error;
    if (v2 < 0 || v2 > 59)
	goto error;

    v3 = (time_t)strtol(p3, &end, 10);
    if (*end != '\0')
	goto error;
    if (v3 < 0 || v3 > 59)
	goto error;

    free (valcopy);

    sec = (v1 * 3600) + (v2 * 60) + v3;
    return (sec);

error:

    (void)sprintf("Can't parse time '%s' into seconds.\n", val);
    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
    DBPRT(("%s: %s\n", id, log_buffer));

    free(valcopy);

    return ((time_t) -1);
}
