/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#ifndef CHECK_H
#define CHECK_H

#include "server_info.h"
#include "queue_info.h"
#include "job_info.h"

/*
 *	is_ok_to_run_in_queue - check to see if jobs can be run in queue
 */
int is_ok_to_run_queue( queue_info *qinfo );

/*
 *	is_ok_to_run_job - check to see if it ok to run a job on the server
 */
int is_ok_to_run_job( int pbs_sd, server_info *sinfo, queue_info *qinfo, 
							job_info *jinfo);

/*
 *      check_avail_resources - check if there is available resources to run
 *                              a job on the server
 */
int check_avail_resources( resource *reslist, job_info *jinfo);


/*
 *	dynamic_avail - find out how much of a resource is available on a 
 */
sch_resource_t dynamic_avail( resource *res );

/* 
 *      check_run_job - function used by job_filter to filter out 
 *                      non-running jobs.
 */
int check_run_job( job_info *job, void *arg );

/*
 *      count_by_user - count the amount of jobs a user has in a job array
 */
int count_by_user( job_info **jobs, char *user );

/*
 *      check_server_max_group_run - check to see if group is within their 
 *                                   server running limits
 */
int check_server_max_group_run( server_info *sinfo, char *group  );

/*
 *      check_queue_max_user_run - check if the user is within queue
 *                                      user run limits
 */
int check_queue_max_user_run( queue_info *qinfo, char *account );

/*
 *      count_by_group - count number of jobs a group has in job array
 */
int count_by_group( job_info **jobs, char *group );


/*
 *      check_server_max_user_run - check if the user is within server
 *                                      user run limits
 */
int check_server_max_user_run( server_info *sinfo, char *account );

/*
 *      check_queue_max_group_run - check to see if the group is within their
 *                                      queue running limits
 */
int check_queue_max_group_run( queue_info *qinfo, char *group );

/*
 *      will_cross_into_ded_time - check to see if a job would cross into
 *                                 dedicated time
 */
int will_cross_ded_time_boundry( job_info *jinfo );

/*
 *      check_nodes - check to see if there is suficient nodes available to
 *                    run a job.
 */
int check_nodes( int pbs_sd, job_info *jinfo, node_info **ninfo_arr );

/*
 *      is_node_available - determine that there is a node available to run
 *                          the job
 */
int is_node_available( job_info *jinfo, node_info **ninfo_arr );

/*
 *      check_ded_time_queue - check if it is the approprate time to run jobs
 *                             in a dedtime queue
 */
int check_ded_time_queue( queue_info *qinfo );


#endif

