/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#ifndef CONFIG_H
#define CONFIG_H

#include "constant.h"

/* resources can get too large for a 32 bit number, so the ability to use the 
 * nonstandard type long long is necessary.  
 */
#define RESOURCE_TYPE long

/* the size (in bytes) of a word.  All resources are kept in kilobytes 
 * internally in the server.  If any specification is in words, it will be
 * converted into kilobytes with this constant
 */
#define SIZE_OF_WORD 8

/* name of config file */
#define CONFIG_FILE "sched_config"
#define USAGE_FILE "usage"
#define HOLIDAYS_FILE "holidays"
#define RESGROUP_FILE "resource_group"
#define DEDTIME_FILE "dedicated_time"

/* parsing - 
 * names that appear on the left hand side in the sched config file
 */
#define PARSE_ROUND_ROBIN "round_robin"
#define PARSE_BY_QUEUE "by_queue"
#define PARSE_STRICT_FIFO "strict_fifo"
#define PARSE_FAIR_SHARE "fair_share"
#define PARSE_HALF_LIFE "half_life"
#define PARSE_SYNC_TIME "sync_time"
#define PARSE_UNKNOWN_SHARES "unknown_shares"
#define PARSE_SORT_BY "sort_by"
#define PARSE_KEY "key"
#define PARSE_LOG_FILTER "log_filter"
#define PARSE_DEDICATED_PREFIX "dedicated_prefix"
#define PARSE_LOAD_BALENCING "load_balancing"
#define PARSE_LOAD_BALENCING_RR "load_balancing_rr"
#define PARSE_HELP_STARVING_JOBS "help_starving_jobs"
#define PARSE_MAX_STARVE "max_starve"
#define PARSE_SORT_QUEUES "sort_queues"

/* max sizes */
#define MAX_HOLIDAY_SIZE 50
#define MAX_DEDTIME_SIZE 50
#define MAX_COMMENT_SIZE 100
#define MAX_LOG_SIZE 100
#define MAX_RES_NAME_SIZE 256
#define MAX_RES_RET_SIZE 256


/* messages -
 * 	INFO - messages printed via info_msg
 *	COMMENT - messages for comments
 */

#define INFO_QUEUE_NOT_STARTED	"Queue not started"
#define INFO_QUEUE_NOT_EXEC	"Queue not an execution queue"
#define INFO_QUEUE_JOB_LIMIT	"Queue job limit reached"
#define INFO_SERVER_JOB_LIMIT	"Server job limit reached"
#define INFO_SERVER_USER_LIMIT	"Server user limit reached"
#define INFO_QUEUE_USER_LIMIT	"Queue user limit reached"
#define INFO_SERVER_GROUP_LIMIT	"Server group limit reached"
#define INFO_QUEUE_GROUP_LIMIT	"Queue group limit reached"
#define INFO_CROSS_DED_TIME	"Job would not finish before dedicated time"
#define INFO_DED_TIME	 	"Dedicated Time"
#define INFO_NO_AVAILABLE_NODE  "No available node to run job"
#define INFO_NOT_QUEUED		"Job is not in queued state"
#define INFO_NOT_ENOUGH_NODES_AVAIL "Not enough of the right type of nodes available"
#define INFO_JOB_STARVING "Draining system to allow %s to run"

#define COMMENT_QUEUE_NOT_STARTED "Not Running: Queue not started."
#define COMMENT_QUEUE_NOT_EXEC    "Not Running: Queue not an execution queue."
#define COMMENT_QUEUE_JOB_LIMIT "Not Running: Queue job limit has been reached."
#define COMMENT_SERVER_JOB_LIMIT "Not Running: Server job limit has been reached."
#define COMMENT_SERVER_USER_LIMIT "Not Running: User has reached server running job limit."
#define COMMENT_QUEUE_USER_LIMIT "Not Running: User has reached queue running job limit."
#define COMMENT_SERVER_GROUP_LIMIT "Not Running: Group has reached server running limit."
#define COMMENT_QUEUE_GROUP_LIMIT "Not Running: Group has reached queue running limit."
#define COMMENT_STRICT_FIFO "Not Running: Strict fifo order"
#define COMMENT_CROSS_DED_TIME "Not Running: Job would cross dedicated time boundry"
#define COMMENT_DED_TIME "Not Running: Dedicated time conflict"
#define COMMENT_NO_AVAILABLE_NODE "Not Running: All timesharing nodes are too loaded to run job"
#define COMMENT_NOT_QUEUED "Not Running: Job not in queued state"
#define COMMENT_NOT_ENOUGH_NODES_AVAIL "Not Running: Not enough of the right type of nodes are available"
#define COMMENT_JOB_STARVING "Not Running: Draining system to allow starving job to run"

#endif
