/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#ifndef CONSTANT_H
#define CONSTANT_H

/* multipliers [bw] means either btye or word */
#define KILO		1024UL		/* number of [bw] in a kilo[bw] */
#define MEGATOKILO 	1024UL		/* number of mega[bw] in a kilo[bw] */
#define GIGATOKILO 	1048576UL	/* number of giga[bw] in a kilo[bw] */
#define TERATOKILO 	1073741824UL	/* number of tera[bw] in a kilo[bw] */

/* extra constants */
#define UNSPECIFIED -1		/* unspecified value */
#define FREE_DEEP 1		/* constant to pass to free_*_list */
#define INITIALIZE -1
#define INFINITY -2		/* infinity value for resources */

/* for update_jobs_cant run */
#define START_BEFORE_JOB -1
#define START_WITH_JOB 0
#define START_AFTER_JOB 1

/* return codes for is_ok_to_run_* functions */
/* codes less then RET_BASE are indexes into the resources to check array */
#define RET_BASE 1000
#define SUCCESS (RET_BASE + 1)
#define SCHD_ERROR (RET_BASE + 2)
#define NOT_QUEUED (RET_BASE + 3)
#define QUEUE_NOT_STARTED (RET_BASE + 4)
#define QUEUE_NOT_EXEC (RET_BASE + 5)
#define QUEUE_JOB_LIMIT_REACHED (RET_BASE + 6)
#define SERVER_JOB_LIMIT_REACHED (RET_BASE + 7)
#define SERVER_USER_LIMIT_REACHED (RET_BASE + 8)
#define QUEUE_USER_LIMIT_REACHED (RET_BASE + 9)
#define SERVER_GROUP_LIMIT_REACHED (RET_BASE + 10)
#define QUEUE_GROUP_LIMIT_REACHED (RET_BASE + 11)
#define DED_TIME (RET_BASE + 12)
#define CROSS_DED_TIME_BOUNDRY (RET_BASE + 13)
#define NO_AVAILABLE_NODE (RET_BASE + 14)
#define NOT_ENOUGH_NODES_AVAIL (RET_BASE + 15)
#define JOB_STARVING (RET_BASE + 16)

/* for SORT_BY */
enum sort_type
{ 
  NO_SORT, 
  SHORTEST_JOB_FIRST, 
  LONGEST_JOB_FIRST, 
  SMALLEST_MEM_FIRST, 
  LARGEST_MEM_FIRST, 
  HIGH_PRIORITY_FIRST, 
  LOW_PRIORITY_FIRST,
  LARGE_WALLTIME_FIRST,
  SHORT_WALLTIME_FIRST,
  FAIR_SHARE,
  MULTI_SORT
};

#ifdef FALSE
#  undef FALSE
#endif

#ifdef TRUE
#  undef TRUE
#endif

enum { FALSE, TRUE };

enum { USER, GROUP };

enum prime_time 
{ 
  ALL, 
  NONE, 
  PRIME, 
  NON_PRIME,
  HIGH_PRIME
};

enum days
{
  SUNDAY,
  SATURDAY,
  WEEKDAY,
  HIGH_DAY
};

#endif
