/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <stdio.h>
#include "globals.h"
#include "constant.h"
#include "sort.h"

static char *ident = "$Id: globals.c,v 2.2 1999/09/28 23:15:59 bmann Exp $";

/*
 *	res_to_check[] - a list of resources which controls what resources
 *			 are checked by the scheduler.
 *
 *	Format: resource_name comment_message debug_message
 *
 *	resource_name: name the server knows the resource as
 *	comment_message: what the comment should be set to if there is not
 *			 enough of this resource available
 *	debug_message: what should be logged as the debug message if there 
 *		       is not enough of this resource available
 *
 */

const struct rescheck res_to_check[] = 
{ 
  {"mem", "Not Running: Not enough memory available", "Not enough memory available"},
  { "ncpus", "Not Running: Not enough cpus available", "Not enough cpus available"}
};

/*
 *
 *	sorting_info[] - holds information about all the different ways you
 *			 can sort the jobs
 *
 *	Format: { sort_type, config_name, cmp_func_ptr }
 *
 *	  sort_type    : an element from the enum sort_type
 *	  config_name  : the name which appears in the scheduling policy config 
 *		         file (sched_config)
 *	  cmp_func_ptr : function pointer the qsort compare function
 *			 (located in sort.c)
 *
 */

const struct sort_info sorting_info[] =
{ 
  {NO_SORT, "no_sort", NULL},
  {SHORTEST_JOB_FIRST, "shortest_job_first", cmp_job_cput_asc},
  {LONGEST_JOB_FIRST, "longest_job_first", cmp_job_cput_dsc},
  {SMALLEST_MEM_FIRST, "smallest_memory_first", cmp_job_mem_asc},
  {LARGEST_MEM_FIRST, "largest_memory_first", cmp_job_mem_dsc},
  {HIGH_PRIORITY_FIRST, "high_priority_first", cmp_job_prio_dsc},
  {LOW_PRIORITY_FIRST, "low_priority_first", cmp_job_prio_asc},
  {LARGE_WALLTIME_FIRST, "large_walltime_first", cmp_job_walltime_dsc},
  {SHORT_WALLTIME_FIRST, "short_walltime_first", cmp_job_walltime_asc},
  {FAIR_SHARE, "fair_share", cmp_fair_share},
  {MULTI_SORT, "multi_sort", multi_sort}
};

/*
 *	res_to_get - resources to get from each nodes mom
 */
const char *res_to_get[] = 
{
  "ncpus",		/* number of CPUS */
  "arch",		/* the architecture of the machine */
  "physmem",		/* the amount of physical memory */
  "loadave",		/* the current load average */
  "max_load",		/* static max_load value */
  "ideal_load"		/* static ideal_load value */	
};

/* number of indicies in the res_to_check array */
const int num_res = sizeof( res_to_check ) / sizeof( struct rescheck );

/* number of indicies in the sorting_info array */
const int num_sorts = sizeof( sorting_info ) / sizeof( struct sort_info );

/* number of indicies in the res_to_get array */
const int num_resget = sizeof( res_to_get ) / sizeof( char * );


struct config conf;
struct status cstat;
