/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#ifndef NODE_INFO_H
#define NODE_INFO_H

#include "data_types.h"
#include <pbs_ifl.h>

/*
 *      query_nodes - query all the nodes associated with a server
 */
node_info **query_nodes( int pbs_sd, server_info *sinfo );

/*
 *      query_node_info - collect information from a batch_status and
 *                        put it in a node_info struct for easier access
 */
node_info *query_node_info( struct batch_status *node, server_info *sinfo );

/*
 *      free_nodes - free all the nodes in a node_info array
 */
void free_nodes( node_info **ninfo_arr );


/*
 *      new_node_info - allocates a new node_info
 */
node_info *new_node_info();

/*
 *      free_node_info - frees memory used by a node_info
 */
void free_node_info( node_info *ninfo );

/*
 *      set_node_state - set a node state
 */
int set_node_state( node_info *ninfo, char *state );

/*
 *      talk_with_mom - talk to mom and get resources
 */
int talk_with_mom( node_info *ninfo );

/*
 *      node_filter - filter a node array and return a new filterd array
 */
node_info **node_filter( node_info **nodes, int size,
                         int (*filter_func) (node_info*, void*), void *arg );


/*
 *      is_node_timeshared - check if a node is timeshared
 */
int is_node_timeshared( node_info *node, void *arg );

/*
 *      find_best_node - find the best node to run a job in a node array
 */
node_info *find_best_node( job_info *jinfo, node_info **ninfo_arr );

/*
 *      find_node_info - find a node in the node array
 */
node_info *find_node_info( char *nodename, node_info **ninfo_arr );

/*
 *      print_node - print all the information in a node.  Mainly used for
 *                   debugging purposes
 */
void print_node( node_info *ninfo, int brief );


#endif
