/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <stdio.h>
#include <stdlib.h>
#include "prev_job_info.h"
#include "job_info.h"

static char *ident = "$Id: prev_job_info.c,v 2.1 1999/04/16 19:28:00 hender Exp $";

/*
 *
 *	create_prev_job_info - create the prev_job_info array from an array 
 *				of jobs
 *
 *	  jinfo_arr - job_info array
 *	  size - size of jinfo_arr or UNSPECIFIED if unknown
 *
 *	returns new prev_job_array
 *
 *	NOTE: jinfo_arr is modified
 *
 */
prev_job_info *create_prev_job_info( job_info **jinfo_arr, int size )
{
  prev_job_info *new;		/* new prev_job_info array */
  int local_size;		/* the size of the array */
  int i;

  if( size == UNSPECIFIED )
  {
    for( i = 0; jinfo_arr[i] != NULL; i++ )
	; 
    
    local_size = i;
  }
  else 
    local_size = size;

  if( ( new = (prev_job_info *) malloc( sizeof( prev_job_info)  * local_size ) ) == NULL )
  {
    fprintf(stderr, "Error allocating memory\n");
    return NULL;
  }

  for( i = 0; jinfo_arr[i] != NULL; i++ )
  {
    new[i].name = jinfo_arr[i] -> name;
    new[i].resused = jinfo_arr[i] -> resused;
    new[i].account = jinfo_arr[i] -> account;
    new[i].ginfo = jinfo_arr[i] -> ginfo;

    /* so the memory is not freed at the end of the scheduling cycle */
    jinfo_arr[i] -> name = NULL;
    jinfo_arr[i] -> resused = NULL;
    jinfo_arr[i] -> account = NULL;
  }

  return new;
}

/*
 *
 *	free_prev_job_info - free a prev_job_info struct
 *
 *	  pjinfo - prev_job_info to free
 *
 *	returns nothing
 *
 */
void free_prev_job_info( prev_job_info *pjinfo )
{
  if( pjinfo -> name != NULL )
    free(pjinfo -> name);
  
  if( pjinfo -> account != NULL )
    free(pjinfo -> account);
  
  free_resource_req_list( pjinfo -> resused );
}

/*
 *
 *	free_pjobs - free a list of prev_job_info structs
 *
 *	  pjinfo_arr - array of prev_job_info structs to free
 *
 *	returns nothing
 *
 */
void free_pjobs( prev_job_info *pjinfo_arr, int size )
{
  int i;

  if( pjinfo_arr == NULL )
    return;
  
  for( i = 0; i < size; i++ )
    free_prev_job_info( &pjinfo_arr[i] );
  
  free(pjinfo_arr);
}
