/*
 *  Any record in the file describes a record in the 
 *  binary PBS accounting file
 */
 
/*
 *  This is the accounting exit record
 */
struct  erec {
	char	tp;		/* record type 			*/
	int	reqid;		/* pbs request id		*/
	int	uid;		/* user id			*/
	int	gid;		/* group id			*/
	char	jname[16];	/* job name			*/
	char	que[16];	/* queue name			*/
	int	ctm;		/* create time			*/
	int	qtm;		/* queued time			*/
	int	etm;		/* end time			*/
	int	strt;		/* start time			*/
	char	ehost[16];	/* exec host			*/
	int	sess;		/* session number		*/
	int	end;		/* end time			*/
	int	estat;		/* exit status			*/

	int	rcput;		/* requested cpu time		*/
	long long	rmem;		/* requested memory		*/
	int	rnce;		/* requested nice value		*/
	int	rncpus;		/* requested ncpus		*/
	int	rmta;		/* requested tape drives A	*/
	int	rmtb;		/* requested tape drives B	*/
	int	rmtc;		/* requested tape drives C	*/
	int	rmtd;		/* requested tape drives D	*/
	int	rmte;		/* requested tape drives E	*/
	int	rmtf;		/* requested tape drives F	*/
	int	rmtg;		/* requested tape drives G	*/
	int	rmth;		/* requested tape drives H	*/
	int	rpncpus;	/* requested process ncpus	*/
	int	rpcput;		/* requested process cput	*/
	int	rpf;		/* requested perm file		*/
	long long	rpmem;		/* requested process mem	*/
	int	rppf;		/* requested process perm file	*/
	int	rprocs;		/* requested # processes	*/
	int	rpsds;		/* requested process sds	*/
	int	rsds;		/* requested sds		*/
	int	rsrfstmp;	/* requested srfs tmp		*/
	int	rsrfsbig;	/* requested srfs big		*/
	int	rsrfswrk;	/* requested srfs work		*/
	int	rsrfsfst;	/* requested srfs fast		*/
	int	rwalltm;	/* requested wall clock		*/
	
	int	ucput;		/* used cpu time used		*/
	long long	umem;		/* used mem used		*/
	int	uncpus;		/* used ncpus used		*/
	int	upncpus;	/* used process ncpus		*/
	int	upcput;		/* used process cput		*/
	long long	upmem;		/* used process memory		*/
	int	uppf;		/* used process perm file	*/
	int	uprocs;		/* used	processes		*/
	int	upsds;		/* used	process sds		*/
	int	upf;		/* used pfile used		*/
	int	uproc;		/* used procs used		*/
	int	usds;		/* used SDS used		*/
	int	usrfsbig;	/* used surface used /big	*/
	int	usrfsfst;	/* used surface used /fast	*/
	int	usrfstmp;	/* used surface used /tmp	*/
	int	usrfswrk;	/* used surface used /wrk	*/
	int	uwalltm;	/* used wall clock 		*/

	int	filler[20];	/* for growth			*/
};

