static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: 
       File:

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:


*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>
#include "gblxvars.h"

static	int *Dfrgrps;
static	int Dfrgcnt;

/*
 *  Given an acid, is it permitted to run in the dfr queue
 */
int
ckgrp(acid)
int	acid;
{
int	x;

	/*
	 *  If no groups eligible then return failure
	 */
	if(Dfrgcnt == 0) {
		return(1);
	}

	/*
	 *  Just in case the file could not be read, allow everyone
	 */
	if(Dfrgcnt == -1)  {
		return(0);
	}

	/*
	 *  Check the array
	 */
	for(x=0;x<Dfrgcnt;x++) {
		if(acid == Dfrgrps[x]) {
			return(0);
		}
	}

	return(1);
}


/*
 *  Read the hostname.defer file which contains
 *  the linear usage for all groups.  Only
 *  remember those groups that are >= LINEAR_USAGE
 *  which is set in the config file.  The file
 *  is processed twice, once to count the number of
 *  groups to remember so an array can be allocated,
 *  and once to store the values in the array.
 */
int
read_dfrgrps()
{
int	x;
FILE	*fd;
char	buf[80];
char	*grp,*pcnt;
char	hostname[MAXHOSTNAMELEN];

	gethostname(hostname,MAXHOSTNAMELEN);

	(void) sprintf(buf,"/usr/local/adm/%s.defer",hostname);
	if((fd=fopen(buf,"r")) == NULL) {
		(void) fprintf(stderr,"can't open %s\n",buf);
		Dfrgcnt = -1;
		return(-1);
	}

	Dfrgcnt = 0;

	/*
	 *  Count the authorized entries so that 
	 *  an array can be allocated
	 */
	while(fgets(buf,80,fd)) {
		buf[strlen(buf)-1] = '\0';
		grp=strtok(buf,"|");
		pcnt = strtok(NULL,"|");
		if(atoi(pcnt) >= LINEAR_USAGE )
			Dfrgcnt++;
	}

	if(Dfrgcnt == 0) {
		fprintf(stderr,"No defer jobs allowed\n");
		fclose(fd);
		return(0);
	}

	/*
	 *  Go back to the beginning of the file
	 */
	rewind(fd);

	/*
	 *  Prevent memory leak
	 */
	if(Dfrgrps)
		free(Dfrgrps);

	/*
	 *  Allocate the array
	 */
	Dfrgrps = (int *)calloc(Dfrgcnt,sizeof(int));

	if(!Dfrgrps) {
		(void) fprintf(stderr,"Memory allocation failure\n");
		(void) fclose(fd);
		return(-1);
	}

	/*
	 *  Now store only those groups that are authorized
	 *  to use the dfr queue
	 */
	x = 0;
	while(fgets(buf,80,fd)) {
		buf[strlen(buf)-1] = '\0';
		grp=strtok(buf,"|");
		pcnt = strtok(NULL,"|");
		if(atoi(pcnt) >= LINEAR_USAGE ) {
			Dfrgrps[x++] = atoi(grp);
		}
	}

	(void) fclose(fd);
	return(0);
}

