
static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libtoolkit.a
       File: how_many.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
   Given a batch_status structure (bs), search the attributes for the 
   requested attribute (at) and return it's value (v).  If the attribute 
   contains a resource list, then search the resource list for the requested
   resource (rs).  The function returns the value if found or a NULL if not
   if the search is not successful.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <string.h>

#include "pbs_ifl.h"

char * getat(at,bs,rs)
char	*at;
struct	batch_status *bs;
char	*rs;
{
char	*id = "getat";
static	char *v;
struct	attrl *a;

	a = bs->attribs;
	v = NULL;

	while(a != (struct attrl *)0L) {
		/*
		 *  Is this the attribute we are looking for
		 */
		if(!strcmp(at,a->name)) {
			/*
			 *  Are we looking for a particular resource
			 */
			if(rs == NULL) {
				v = a->value;
				break;
			} else if(!strcmp(rs,a->resource)) {
				v = a->value;
				break;
			}
		}

		a = a->next;
	}

	return(v);
}

