static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libtoolkit.a
       File: how_many.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Given a state_count string, return the integer value
    of the state requested.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>

int how_many(str,state)
char	*str;
char	*state;
{
char	*id = "how_many";
char	*avalue,*ptr1,*ptr2;

	/*
	 *  Make a duplicate to work from
	 */
	if((avalue = strdup(str)) == NULL)
		return(0);

	/*
	 *  Locate the requested state
	 */
	if((ptr1=strtok(avalue," ")) == NULL) 
		return(0);

	while(strncmp(state,ptr1,strlen(state))) {
		ptr1 = strtok(NULL," ");
		if(ptr1 == NULL)
			return(0);
	}

	/*
	 *  Locate the number after the colon
	 */
	ptr2 = strstr(ptr1,":");
	ptr2++;

	/*
	 *  Prevent a memory leak so free the duplicate
	 */
	free(avalue);

	/*
	 *  return the value
	 */
	return(atoi(ptr2));
}
