static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: pbs_sched.a
       File: runqueue.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Attempt to run a job out of the specified queue.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>

#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"
#include "toolkit.h"

int run_queue(qname,flag)
char	*qname;
int	flag;
{
char	*id = "run_queue";
static	struct	batch_status *bs;
int	rtc;

	rtc = 0;

	/*
	 *  Check the queue limits
	 */
	if(queue_limits(qname)) 
		return(rtc);

	/*
	 *  Get the jobs in the queue, then select and run
	 *  run a job.
	 */
	if((bs=getjobs(qname,"Q")) != (struct batch_status *)0L) {
		if(seljob(bs,qname,flag))
			rtc = 1;
	}


	/*
	 *  Clean up to prevent a memory leak
	 */
	pbs_statfree(bs);

	return(rtc);
}

