static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libtoolkit.a
       File: val2byte.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Convert a value string for an allocation to 
    its equivalent value in bytes.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>

#include "toolkit.h"

long long val2byte(val)
char	*val;
{
char	*id = "val2byte";
char	*p;
long long num;
int	b;
/*
char buffer[1000];
*/

	if (val == NULL)
	    return(0L);

	b = 0;
	num = 0L;
	num = strtoll(val,&p,0);
/*
(void) sprintf(buffer,"1: val=[%s] num=%lld, p=[%s]",val,num,p);
log_record(1,1,id,buffer);
*/


	if (num == 0)
	    num = strtol(val,&p,0);

	/*
	 *  No qualifiers so assume bytes already
	 */
	if((p == val) || (*p == '\0'))
		return(num);

	/*
	 *  Parse the order of magnitude
	 */
	switch(*p) {
		case 'k':
		case 'K':
			num *= KILO;
			break;

		case 'm':
		case 'M':
			num *= MEGA;
			break;

		case 'g':
		case 'G':
			num *= GIGA;
			break;

/*
		case 't':
		case 'T':
			num *= TERA;
			break;
*/
		case 'b':
		case 'B':
			b++;
			break;

		default:
			return(-1);
	}

	/*
	 *  Parse the unit
	 */
	p++;
	if((*p != '\0') && !b) {
		switch(*p) {
			case 'b':
			case 'B':
				break;

			case 'w':
			case 'W':
				num *= NBPW * 2;
				break;

			default:
				return (-1);
		}
	}

	/*
	 *  Return the number of bytes
	 */
	return(num);
}
