/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 *  Any record in the file describes a record in the 
 *  binary PBS accounting file
 */
 
/*
 *  This is the accounting exit record
 */
struct  erec {
	char	tp;		/* record type 			*/
	int	reqid;		/* pbs request id		*/
	int	uid;		/* user id			*/
	int	gid;		/* group id			*/
	char	jname[16];	/* job name			*/
	char	que[16];	/* queue name			*/
	int	ctm;		/* create time			*/
	int	qtm;		/* queued time			*/
	int	etm;		/* end time			*/
	int	strt;		/* start time			*/
	char	ehost[16];	/* exec host			*/
	int	sess;		/* session number		*/
	int	end;		/* end time			*/
	int	estat;		/* exit status			*/

	int	rcput;		/* requested cpu time		*/
	long long	rmem;		/* requested memory		*/
	int	rnce;		/* requested nice value		*/
	int	rncpus;		/* requested ncpus		*/
	int	rmta;		/* requested tape drives A	*/
	int	rmtb;		/* requested tape drives B	*/
	int	rmtc;		/* requested tape drives C	*/
	int	rmtd;		/* requested tape drives D	*/
	int	rmte;		/* requested tape drives E	*/
	int	rmtf;		/* requested tape drives F	*/
	int	rmtg;		/* requested tape drives G	*/
	int	rmth;		/* requested tape drives H	*/
	int	rpncpus;	/* requested process ncpus	*/
	int	rpcput;		/* requested process cput	*/
	int	rpf;		/* requested perm file		*/
	long long	rpmem;		/* requested process mem	*/
	int	rppf;		/* requested process perm file	*/
	int	rprocs;		/* requested # processes	*/
	int	rpsds;		/* requested process sds	*/
	int	rsds;		/* requested sds		*/
	int	rsrfstmp;	/* requested srfs tmp		*/
	int	rsrfsbig;	/* requested srfs big		*/
	int	rsrfswrk;	/* requested srfs work		*/
	int	rsrfsfst;	/* requested srfs fast		*/
	int	rwalltm;	/* requested wall clock		*/
	
	int	ucput;		/* used cpu time used		*/
	long long	umem;		/* used mem used		*/
	int	uncpus;		/* used ncpus used		*/
	int	upncpus;	/* used process ncpus		*/
	int	upcput;		/* used process cput		*/
	long long	upmem;		/* used process memory		*/
	int	uppf;		/* used process perm file	*/
	int	uprocs;		/* used	processes		*/
	int	upsds;		/* used	process sds		*/
	int	upf;		/* used pfile used		*/
	int	uproc;		/* used procs used		*/
	int	usds;		/* used SDS used		*/
	int	usrfsbig;	/* used surface used /big	*/
	int	usrfsfst;	/* used surface used /fast	*/
	int	usrfstmp;	/* used surface used /tmp	*/
	int	usrfswrk;	/* used surface used /wrk	*/
	int	uwalltm;	/* used wall clock 		*/

	int	filler[20];	/* for growth			*/
};

