/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: 
       File:

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:


*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>
#include "gblxvars.h"

static	int *Dfrgrps;
static	int Dfrgcnt;

/*
 *  Given an acid, is it permitted to run in the dfr queue
 */
int
ckgrp(acid)
int	acid;
{
int	x;

	/*
	 *  If no groups eligible then return failure
	 */
	if(Dfrgcnt == 0) {
		return(1);
	}

	/*
	 *  Just in case the file could not be read, allow everyone
	 */
	if(Dfrgcnt == -1)  {
		return(0);
	}

	/*
	 *  Check the array
	 */
	for(x=0;x<Dfrgcnt;x++) {
		if(acid == Dfrgrps[x]) {
			return(0);
		}
	}

	return(1);
}


/*
 *  Read the hostname.defer file which contains
 *  the linear usage for all groups.  Only
 *  remember those groups that are >= LINEAR_USAGE
 *  which is set in the config file.  The file
 *  is processed twice, once to count the number of
 *  groups to remember so an array can be allocated,
 *  and once to store the values in the array.
 */
int
read_dfrgrps()
{
int	x;
FILE	*fd;
char	buf[80];
char	*grp,*pcnt;
char	hostname[MAXHOSTNAMELEN];

	gethostname(hostname,MAXHOSTNAMELEN);

	(void) sprintf(buf,"/usr/local/adm/%s.defer",hostname);
	if((fd=fopen(buf,"r")) == NULL) {
		(void) fprintf(stderr,"can't open %s\n",buf);
		Dfrgcnt = -1;
		return(-1);
	}

	Dfrgcnt = 0;

	/*
	 *  Count the authorized entries so that 
	 *  an array can be allocated
	 */
	while(fgets(buf,80,fd)) {
		buf[strlen(buf)-1] = '\0';
		grp=strtok(buf,"|");
		pcnt = strtok(NULL,"|");
		if(atoi(pcnt) >= LINEAR_USAGE )
			Dfrgcnt++;
	}

	if(Dfrgcnt == 0) {
		fprintf(stderr,"No defer jobs allowed\n");
		fclose(fd);
		return(0);
	}

	/*
	 *  Go back to the beginning of the file
	 */
	rewind(fd);

	/*
	 *  Prevent memory leak
	 */
	if(Dfrgrps)
		free(Dfrgrps);

	/*
	 *  Allocate the array
	 */
	Dfrgrps = (int *)calloc(Dfrgcnt,sizeof(int));

	if(!Dfrgrps) {
		(void) fprintf(stderr,"Memory allocation failure\n");
		(void) fclose(fd);
		return(-1);
	}

	/*
	 *  Now store only those groups that are authorized
	 *  to use the dfr queue
	 */
	x = 0;
	while(fgets(buf,80,fd)) {
		buf[strlen(buf)-1] = '\0';
		grp=strtok(buf,"|");
		pcnt = strtok(NULL,"|");
		if(atoi(pcnt) >= LINEAR_USAGE ) {
			Dfrgrps[x++] = atoi(grp);
		}
	}

	(void) fclose(fd);
	return(0);
}

