/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: pbs_sched.a
       File: schedinit.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Perform any scheduler initialization.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include "gblxvars.h"
#include "pbs_ifl.h"
#include "log.h"

char	schedhost[255];

void    catchUSR1(int signo);
void	catchHUP(int signo);
void	setalarm(void);

/*
 *  Perform scheduler initialization stuff here
 */
int schedinit(argc,argv)
int	argc;
char	**argv;
{
char	*id = "schedinit";

	/*
	 *  Read the configuration file
	 */
	if (getconfig())
		return(-1);

	/*
	 *  Read the holidays file to determine
	 *  prime and non-prime times.
	 */
	read_holidays();

	/*
	 *  set the signal for rereading the config file
	 */
	signal(SIGHUP,catchHUP);

	/*
	 *  What host is this scheduler running on
	 */
	gethostname(schedhost,255);

	/* any other required initializations: */
	need_to_get_alloc_info = 1;     /* get per-group allocation info */
	need_to_get_YTD_info   = 1;     /* get per-group YTD usage info */

	return(0);
}

/*
 *  read the linear usage file
 */
void
catchUSR1(signo)
int	signo;
{
char	*id = "catchUSR1";

	signal(SIGUSR1,catchUSR1);
}

void
setalarm()
{
time_t	tim;
struct	tm *tm;
int	now;
int	tday;
char	*id = "setalarm";

	/*
	 *  Reset the next alarm
	 */
	time(&tim);
	tm = localtime(&tim);

	/*
	 *  Calculate how many seconds until 0600 tomorrow
	 */
	now = (tm->tm_hour * 60) + tm->tm_min;  /* minutes from 0000 */
	tday = 1440 - now;                      /* minutes till 2400 */
	tday *= 60;                             /* seconds till 2400 */
	tday += 21600;                          /* seconds till 0600 */

	alarm(tday);
}

/*
 *  read the configuration file
 */
void
catchHUP(signo)
int	signo;
{
time_t	tim;
struct	tm *tm;
int	now;
int	tday;
char	*id = "catchHUP";

	(void) sprintf(log_buffer,"SIGHUP: reread configuration file");
	log_record(PBSEVENT_SYSTEM,PBS_EVENTCLASS_SERVER,id,log_buffer);

	clrcomp();
	getconfig();

	/*
	 *  reset the signal
	 */
	signal(SIGHUP,catchHUP);

}
