/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libtoolkit.a
       File: sendmsg.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Given a state_count string, return the integer value
    of the state requested.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#ifdef _UNICOS

#include <stdio.h>
#include <sys/types.h>
#include <msg.h>
#include <msg_funcs.h>
#include <sys/fcntl.h>
#include <sys/param.h>
#include <sys/stat.h>

static	struct	repname	reptbl[OPEN_MAX];

int send_message(msgp,msgt)
char    *msgp;
int	msgt;
{
struct  msghdr  hdr;
struct	fs	repfs;
char	*rep;
char	*buf;
int     fd;
int     c;
int	tmout;
int	msg_size;

	if((msg_size=strlen(msgp)) == 1)
		return(-1);

	memset (&hdr, '\0', sizeof (struct msghdr));

	rep = tempnam(NULL,NULL);

	strcpy(repfs.fn,rep);

	if((repfs.fd = makepipe(repfs.fn)) < 0)
		return(-1);

	if((fd = open(MSG_PIPE,O_WRONLY|O_NDELAY)) < 0) {
		close(repfs.fd);
		unlink(repfs.fn);
                return(-1);
        }

	hdr.func = msgt;

        strcpy(hdr.reply_pipe_name,repfs.fn);
 
        hdr.msg_size = msg_size;

	while ((buf = (char *) malloc(msg_size+sizeof(struct msghdr))) == NULL)
                sleep(1);

	COPYB(buf,&hdr,sizeof(struct msghdr));
	COPYB(buf+sizeof(struct msghdr),msgp,hdr.msg_size);

        if((c = write(fd,buf,msg_size+sizeof(struct msghdr))) < 0) {
		close(fd);
		free(buf);
		close(repfs.fd); 
		unlink(repfs.fn);
                return(-1);
        }
 
        close(fd);
	free(buf);

	tmout = 0;
	for(;;) {
                if((c = read(repfs.fd,&hdr,sizeof(struct msghdr))) == 0) {
			if (tmout >= TIME_LIMIT) {
				close(repfs.fd);
				unlink(repfs.fn);
				return(-1);
			}
                        sleep(1);
			tmout++;
                        continue;
                } else if (c < 0) {
			close(repfs.fd);  
			unlink(repfs.fn);
                        return(-1);
                }
         
                break;
        }

	if (hdr.status > 0) {
		return(-1);
	}
	strcpy(reptbl[repfs.fd].fn,repfs.fn);
	reptbl[repfs.fd].mnum = hdr.msg_number;
	return(hdr.msg_number);	
}

int receive_reply(msg_number,repp,wait)
int     msg_number;
char    **repp;
int	wait;
{
struct  msghdr  hdr;
struct	fs	repfs;
char    *buf;
int	c;
int	found;
 
	*repp = NULL;
	found = 0;

	for (c = 0;c < OPEN_MAX;c++) {
		if (reptbl[c].mnum == msg_number) {
			strcpy(repfs.fn,reptbl[c].fn);
			repfs.fd = c;
			found++;
			break;
		}
	}

	if (!found)
		return(-1);

	for(;;) {
		if((c = read(repfs.fd,&hdr,sizeof(struct msghdr))) == 0) {
			if (wait) {
                        	sleep(1);	
                        	continue;
			} else {
				return(0);
			}	
                } else if (c < 0) {
			reptbl[repfs.fd].mnum = 0;
			close(repfs.fd);
			unlink(repfs.fn);
                        return(-1);
                }

		reptbl[repfs.fd].mnum = 0;
                break;
        }

	if (hdr.status > 0) {
		close(repfs.fd); 
		unlink(repfs.fn);
		return(-1);
	}

	if (hdr.msg_size) {
        	if ((buf = (char *) malloc(hdr.msg_size)) == NULL) {
			close(repfs.fd);    
                	unlink(repfs.fn);  
                	return(-1);
        	}

        	if((c = read(repfs.fd,buf,hdr.msg_size)) < 0) {
			close(repfs.fd);    
                	unlink(repfs.fn);  
                	return(-1);
        	}

        	*repp = buf;
	}

	close(repfs.fd);
	unlink(repfs.fn);

	return(hdr.msg_size);
}

static int makepipe(path)
char    *path;
{
int     c;
int     ruid;
int     egid;
int	mode;

	ruid = getuid();
	egid = getegid();
	mode = S_IFIFO|S_IRWXU;

	unlink(path);
	if ((c = mknod(path,mode,0)) < 0) { 
		return(-1);
	}

	if ((c = chmod(path,mode)) < 0) {
		unlink(path);
		return(-1);
	}

	if ((c = chown(path,ruid,egid)) < 0) {
		unlink(path);
		return(-1);
	}

	if ((c = open(path,O_RDONLY|O_NDELAY)) < 0) { 
		unlink(path);           /* get rid of it */
		return(-1);
	}

	return(c); 
}

#endif
