/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* USMID %Z%%M%	%I%	%G% %U% */

/*
 *  STDC and K&R C interface declarations
 */
#if defined(__STDC__) || defined (__cplusplus)
#define __(_A) _A
#else
#define __(_A) ()
#endif 

#include "pbs_ifl.h"

#define	UNSPECIFIED -1

#ifndef UNICOS
#define BSIZE 512
#endif 

/*
 *  Valid state count search strings
 */
#define SC_TRANSIT "Transit"
#define SC_QUEUED  "Queued"
#define SC_HELD    "Held"
#define	SC_WAITING "Waiting"
#define	SC_RUNNING "Running"
#define	SC_EXITING "Exiting"

/*
 *  Allocation units order of magnitude
 */
#define KILO (1024)
#define MEGA (KILO*1024)
#define GIGA (MEGA*1024)
#define TERA (GIGA*1024)

/*
 *  Scheduler configuration file.  Can be overridden
 *  by environment variable PBSSCHED_CONFIG
 */
#define CONFIGFILE "/PBS/sched_priv/config"

/*
 *  denied user list for complex limits
 */
struct  denied_user {
        char    user[16];
	char	*reason;
        struct  denied_user *next;
};

/*
 *  queue complex structure
 */
struct	qcomplex {
	char name[16];		/* complex name    */
	int  jobs;		/* job limit       */
	long long  mem;		/* memory limit    */
	int  cpu;		/* cpu time limit  */
	char router[16];	/* the route queue */
	char *members;		/* member queues   */
	struct denied_user *du; /* users denied    */
	struct qcomplex *next;	/* next complex    */
};

/*
 *  queue list structure for complexes
 */
struct	qlist {
	char name[16];		/* queue name         */
	struct qcomplex *qcom;	/* complex membership */
	struct qlist *next;	/* next queue         */
};

struct	routeq {
	char name[16];
	char *qlist;
	struct routeq *next;
};

struct	rqlist {
	char	name[16];
	long long mem;
	int	cput;
};

#define DBDAT "/PBS/sched_priv/pbsdb.dat"
#define DBIDX "/PBS/sched_priv/pbsdb.idx"

struct	hrec {
	char	user[16];
	int	int_use;
	int	int_lim;
	int	max_use;
	int	max_lim;
	char	expire[16];
	long long memory;
	int	filler[10];
};

struct	hidx {
	char	user[16];
	int	pos;
};

/*
 *  This structure is used to hold information about
 *  a queue
 */
struct	qinfo {
	int	maxrun; 	/* Run limit */
	int	started;	/* queue state */
	int	running;	/* #jobs running in queue */
	int	queued;		/* #jobs queued */
};

struct	assist {
	char	*jobname;
	long long memory;
	int	srfsfast;
	int	srfsbig;
	int	qtime;
};

struct	strvent {
	char	*qlist;
	struct	strvent *next;
};

struct	qthresh {
	char	*qname;
	int	starve;
	struct	qthresh *next;
};

struct	pqueues {
	char	*queue_name;
	struct 	pqueues *next;
};

/*
 *  This structure is used to hold the values returned by 
 *  the resource monitor.
 */
struct	resutl {
	int	  usrtime;	/* %user */
	int	  systime;	/* %system */
	int	  idltime;	/* %idle */
	int	  gsttime;	/* %guest */
	long long freemem;	/* free memory (bytes) */
	long long batchmem;	/* used batch memory (bytes) */
	long long realmem;	/* Physical memory (bytes) */
	int	  ncpus_total;	/* Number of CPUs on system */
	int	  ncpus_alloc;	/* Number of CPUs allocated */
	long long dfrmem;	/* deferred job memory usage */
	int	  loadave;	/* load average */
	long long swapinrate;	/* Blocks/second swap in rate */
	int	  njobs;  	/* number of jobs running */
	int	  lrgmtcnt;	/* large memory mt job count */
	int	  lrgcnt;	/* large memory non-mt job count */
	long long lrgmem;	/* memory allocated to large jobs */
};

/* per-group allocation and usage database */
#ifndef MAX_USER_NAME_SIZE
#define MAX_USER_NAME_SIZE 10
#endif
#ifndef MAX_GROUP_NAME_SIZE
#define MAX_GROUP_NAME_SIZE 10
#endif
#ifndef MAX_GROUP
#define MAX_GROUP 250
#endif
#ifndef MAX_USERS
#define MAX_USERS 30
#endif
#ifndef MAXTXT
#define MAXTXT 127
#endif


extern int 	ENFORCE_ALLOC;
extern int 	n_Allocation;
extern char 	*SCHED_ACCT_DIR;

struct alloc_group {
	char    gid[MAX_GROUP_NAME_SIZE];
	double  total_usage;
	double  allocation;
};
extern struct alloc_group group_table[MAX_GROUP];

/*
struct alloc_group {
    	char   	gid[MAX_GROUP_NAME_SIZE];
    	double 	total_usage;
    	double 	allocation;
};
*/

/*
 *  assist.c
 */
extern int ckassist __((void));
extern void clear_assist __((void));
extern int run_assist __((struct resutl *_Rsrcs));
extern void create_starvlist __((char *_Qlist));
extern int read_thresh __((void));
extern int jobsrt __((const void *_A, const void *_B));


/*
 *  complex.c
 */
extern int create_complex __((char * _Cfg_option, char *_Qs));
extern int create_qlist __((char *_Cfg_arg));
extern int qcset __((char *_Cname, char *_Tlim, char *_Lim));
extern int create_router __((char *_Cfg_arg));
extern void clrcomp __((void));

/*
 *  dbfuncs.c
 */
extern struct hrec *dbdat __((char *_User));
extern int dbpos __((char *_User));
extern int updatedb __((struct hrec *_Hu));
extern int usrok __((char *_User, int _Cputim));

/*
 *  getat.c
 */
extern char *getat __((char *_At, struct batch_status *_Bs, char *_Rs));

/*
 *  getconfig.c
 */
extern int getconfig __((void));
extern void prtconfig __((void));

/*
 *  getjobs.c
 */
extern struct batch_status *getjobs __((char *_Qname, char *_State));

/*
 *  getrsrcs.c
 */
extern struct resutl *get_resutl __((void));

/*
 *  how_many.c
 */
extern int how_many __((char *_Str, char *_State));

/*
 *  pnp.c
 */
extern int pnp __((void));
extern int read_holidays __((void));

/*
 *  qenabled.c
 */
extern int qenabled __((char *_Queue_name));

/*
 *  queue_limits.c
 */
extern int queue_limits __((char *_Queue_name));
extern int user_limits __((struct batch_status *_Bs, char *_Qname));


/*
 *  router.c
 */
extern int router __((char *_Rqueue));
extern int compar __((const void *_A, const void *_B));

/*
 *  sec2val.c
 */
extern char *sec2val __((int _Seconds));


/*
 *  sendmsg.c
 */
extern int send_message __((char *_Msgp, int _Msgt));
extern int receive_reply __((int _Msg_number, char **_Repp, int _Wait));

#if SRFS == 1
/*
 *  srfs.c
 */
extern int srfs_check __((struct batch_status *_Bs));
extern int srfs_clear __((void));
extern int srfs_assist __((void));
#endif

/*
 *  val2byte.c
 */
extern long long val2byte __((char *_Val));


/*
 *  val2sec.c
 */
extern int val2sec __((char *_Val));


/*
 * parsys_funcs.c
 */
extern int 	is_new_allocations_file __((void));
extern int 	is_new_current_file __((void));
void 		sched_alloc_info __((void));
static int 	cmp __((const void *_A, const void *_B));
int		MMDDYYYY_HHMM __((char *_Mmddyyyy,char *_Hhmm));
int 		HHMMSS __((char *_Spec,int *_Hours,int *_Mins,int *_Secs));
int 		hhmmss __((char *_Spec));
char 		*timestr __((int _Seconds_since_1969, char *_P));
void 		sched_dedicated_time __((void));
int 		is_over_allocation __((char *_Group));
float 		get_allocation __((char *_Gid));
float 		get_FY_used __((char *_Gid));
int 		over_allocation __((struct batch_status *_Bs, int _Scon, int _Rcon, int _Rep_only));
void 		report_skip_job __((struct batch_status *_Bs, char *_Reason));
int 		dedicated_can_run __((int _sv_conn, int _r_conn, struct batch_status *_Bs));
int 		sched_alterjob __((int _Sv_conn, struct batch_status *_Bs, char* _Name, char* _Value, char* _Resource));

