/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* $Id: cleanup.c,v 1.2 1999/11/17 01:21:17 hender Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <string.h>

/* PBS header files */

#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"

/* Scheduler header files */

#include "toolkit.h"
#include "gblxvars.h"

static int cleanup_queue(Queue *queue);
static int cleanup_rsrcs(Resources *rlist);

int 
schd_cleanup(void)
{
    QueueList *qptr;

    for (qptr = schd_SubmitQueue; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    for (qptr = schd_BatchQueues; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    for (qptr = schd_DedQueues; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    for (qptr = schd_SpecialQueue; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    for (qptr = schd_ExternQueues; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    if (schd_AllJobs) {
	schd_free_jobs(schd_AllJobs);
	schd_AllJobs = NULL;
    }

    if (schd_RsrcsList) {
	cleanup_rsrcs(schd_RsrcsList);
	schd_RsrcsList = NULL;
    }

    return (0);
}

static int
cleanup_queue(Queue *queue)
{
    char *qname, *exechost;
    time_t idle_since;
    int   pt_obsvd;

    if (queue->jobs)
	schd_free_jobs(queue->jobs);

    if (queue->useracl)
	schd_free_useracl(queue->useracl);

    /* 
     * Rather than explicitly zeroing out all the fields in the queue, save
     * a reference to the queue name and host, which is all that is needed 
     * to identify the queue next time it is used.  Note that this sets the
     * jobs list to NULL, so it will not be accidentally traversed.
     *
     * Be sure to save and restore any other necessary information here!
     */

    qname      = queue->qname;
    exechost   = queue->exechost;
    idle_since = queue->idle_since;
    pt_obsvd   = queue->observe_pt;

    memset (queue, 0, sizeof (Queue));

    queue->qname      = qname;
    queue->exechost   = exechost;
    queue->idle_since = idle_since;
    queue->observe_pt = pt_obsvd;

    return (0);
}

static int 
cleanup_rsrcs(Resources *rlist)
{
    Resources *rptr, *next;
    int    num = 0;

    for (rptr = rlist; rptr != NULL; rptr = next) {
	next = rptr->next;

	if (rptr->exechost)
	    (void)free(rptr->exechost);

	(void)memset (rptr, 0, sizeof (Resources));
	(void)free(rptr);

	num ++;
    }

    return (num);
}
