/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* $Id: hpm.h,v 1.1 1999/04/16 19:33:08 hender Exp $ */
#ifndef HPM_H_
#define HPM_H_

/*
 * HPM stands for Harware Performance Monitor.  This is an attribute that
 * allows users to take advantage of such software as "perfex". SGI 
 * Origin2000's only allow one global counter at a time, so when the system 
 * is using it users are unable to and vice versa.
 * 
 * This functionality is implemented by having the PBS Resource Monitor
 * execute the script with the given argument.  Consult the script for
 * further information.
 *
 * HPM_ATTRIBUTE is the name of the PBS resource attribute that jobs use to 
 * specify that they want to use the HPM counters (i.e. to run `perfex(1)')
 *
 * HPM_CTL_FORMAT_STR is a 'sprintf(3)' template for the addreq() resmom
 * call.  The '%s' should be replaced with one of the following strings.
 * The call wi
 *
 * HPM_CTL_USER_STR is the string used by the script to indicate that the
 * system is in user mode.  The command 'hpm_ctl $HPM_CTL_USERMODE', if run
 * by a privileged user, should set up the system for user mode.
 *
 * HPM_CTL_GLOBAL_STR is the string used by the script to indicate that the
 * system is in user mode.  The command 'hpm_ctl $HPM_CTL_GLOBALMODE', if 
 * run by a privileged user, should set up the system for system mode.
 *
 * HPM_CTL_QUERY_STR is the string to pass to the script to get the current
 * state of the execution host.
 *
 * HPM_CTL_OKAY_STR is returned by hpm_ctl if it successfully set the system
 * to the requested mode.
 *
 * HPM_CTL_ERROR_STR is the string prefixing an error message from hpm_ctl.
 */

#define HPM_ATTRIBUTE		"hpm"

#define HPM_CTL_FORMAT_STR	"hpm_ctl[mode=%s]"
#define HPM_CTL_QUERY_STR	"query"
#define HPM_CTL_USERMODE_STR	"user"
#define HPM_CTL_GLOBALMODE_STR	"global"
#define HPM_CTL_REVOKE_STR	"revoke"

#define HPM_CTL_OKAY_STR	"OKAY"
#define HPM_CTL_ERROR_STR	"ERROR"

/* Legal modes to pass into schd_hpm_setup()  */
#define HPM_SETUP_USERMODE	1
#define HPM_SETUP_GLOBALMODE	2
#define HPM_SETUP_REVOKE	3

#endif /* HPM_H_ */
