/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* $Id: val2sec.c,v 1.1 1999/04/16 19:34:19 hender Exp $ */

/*
 *  Convert a value string from time to its equivalent value in seconds.
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pbs_ifl.h"
#include "log.h"

#include "toolkit.h"

time_t 
schd_val2sec(char *val)
{
    char   *id = "val2sec";
    char   *p1, *p2, *p3, *end, *zero = "0";
    time_t  v1, v2, v3;
    time_t  sec;
    char   *valcopy;

    p3 = NULL;

    valcopy = schd_strdup(val);
    if (valcopy == NULL) {
	(void)sprintf(log_buffer, "schd_strdup(val) failed.");
	log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	DBPRT(("%s: %s\n", id, log_buffer));
	return ((time_t) -1);
    }

    /* Split string into at most 3 tokens. */
    p1 = strtok(valcopy, ":");
    p2 = strtok(NULL, ":");
    if (p2 != NULL) {
	p3 = strtok(NULL, ":");
    }

    /* Only seconds specified.  Shift right 2 places into p3, and zero fill */
    if (p2 == NULL) {
	p3 = p1;
	p2 = zero;
	p1 = zero;
    }

    /* Minutes and seconds specified.  Shift right into p3, and zero fill */
    if (p3 == NULL) {
	p3 = p2;
	p2 = p1;
	p1 = zero;
    }

    v1 = (time_t)strtol(p1, &end, 10);
    if (*end != '\0')
	goto error;
    if (v1 < 0)
	goto error;

    v2 = (time_t)strtol(p2, &end, 10);
    if (*end != '\0')
	goto error;
    if (v2 < 0 || v2 > 59)
	goto error;

    v3 = (time_t)strtol(p3, &end, 10);
    if (*end != '\0')
	goto error;
    if (v3 < 0 || v3 > 59)
	goto error;

    free (valcopy);

    sec = (v1 * 3600) + (v2 * 60) + v3;
    return (sec);

error:

    (void)sprintf("Can't parse time '%s' into seconds.\n", val);
    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
    DBPRT(("%s: %s\n", id, log_buffer));

    free(valcopy);

    return ((time_t) -1);
}
