#!/usr/local/bin/pbs_tclsh
#
# $Id: sched_init.tcl,v 1.1 1999/04/16 00:05:56 hender Exp $
#
# $Log: sched_init.tcl,v $
# Revision 1.1  1999/04/16 00:05:56  hender
# Restore old sample Tcl scheduler just for the fun of it
#
# Revision 1.1.2.1  1997/03/07 00:28:58  hender
# Add sample tcl scripts from Other sites.
#
# Revision 1.10  1996/07/08  17:45:18  tmillima
# added vesta queue
#
# Revision 1.9  1996/06/26  19:37:34  tmillima
# modified sorting jobs by priority
#
# Revision 1.8  1996/06/03  16:16:59  tmillima
# changed some parameters and added queues for pallas
#
# Revision 1.7  1995/06/29  13:22:22  tmillima
# added hostlist for queue long2
# quit
#
# Revision 1.6  1995/05/16  21:03:42  tmillima
# took out diagnostic puts statements
#
# Revision 1.5  1995/05/16  21:00:20  tmillima
# rewrote job sorting so that submission order is preserved
# when sorting jobs from queues with same priority
#
# Revision 1.4  1995/05/12  13:21:41  tmillima
# added routine to sort job info by queue priority
#
# Revision 1.3  1995/04/24  20:26:34  tmillima
# updated before install
#
# Revision 1.2  1995/04/24  14:06:48  tmillima
# Moved some stuff from sched_body.tcl to here.
#
# Revision 1.1  1995/04/19  15:21:37  tmillima
# Initial revision
#
# PBS Scheduler initialization file
#
# PBS scheduler procedures
#
# Procedure for extracting relevant info from attribute-value structure
#
proc getattrlval {item sinfo} {
    set name [lindex $sinfo 0]
    set attrl [lindex $sinfo 1]
    switch -- $item {
	"name" {return $name}
	default {return [keylget attrl $item]}
    }
}
#
# Procedure for extracting various counts from the state count string
#
proc getcntval {item cntinfo} {
    set cntstring [lindex $cntinfo [lsearch $cntinfo [set item]:* ]]
    return [lindex [split $cntstring ":"] 1]
}
#
# sorting function to order two jobs by priority
#
proc bypriority {priority j1 j2} {
    #
    # get job1 priority
    #
    set attrl [lindex $j1 1]
    set jobid1 [lindex $j1 0]
    set qattr [keylget attrl queue]
    set pri1 [keylget priority $qattr]
    #
    # get job2 priority
    #
    set attrl [lindex $j2 1]
    set jobid2 [lindex $j2 0]
    set qattr [keylget attrl queue]
    set pri2 [keylget priority $qattr]
    #
    unset qattr
    unset attrl
    #
    # return -1 if job1 priority is less than job2 priority
    #
    if { $pri1 == $pri2 } {return 0}
    if { $pri1 < $pri2 } {return -1}
    if { $pri1 > $pri2 } {return 1}
    #
}
#
# procedure for sorting job info based on queue priority
#
proc sortjobinfo {priority name1} {
    # 
    # pass job info structure by reference
    #
    upvar $name1 jobs
    #
    # get list of queues
    #
    set qlist [keylkeys priority]
    #
    # get list of unique queue priority values
    #
    foreach queue $qlist {
	lappend qp [keylget priority $queue]
    }
    set newqp [lsort -integer -decreasing [lrmdups $qp]]
    #
    # sort through the job list once for each priority
    # pulling out the jobs for that priority.
    #
    set tempjobs $jobs
    if {[info exists newjobs]} {unset newjobs}
#    foreach qp $newqp {
#	set njobs [llength $tempjobs]
#	for {set nj 0} {$nj < $njobs} {incr nj 1} {
#	    set jobstruct [lindex $tempjobs $nj]
#	    set jobid [lindex $jobstruct 0]
#	    set attrl [lindex $jobstruct 1]
#	    set qattr [keylget attrl queue]
#	    set pri [keylget priority $qattr]
#	    if { "$pri" == "$qp" } {
#		lappend newjobs "$jobstruct"
#	    }
#	}
#    }
#    set njobs [llength $newjobs]
#    for {set nj 0} {$nj < $njobs} {incr nj 1} {
#	set jobstruct [lindex $newjobs $nj]
#	set jobid [lindex $jobstruct 0]
#    }
    set newjobs [lsort -decreasing -command {bypriority "$priority"} $tempjobs]
    #
    # update the jobs structure in the scope of the calling routine
    #
    set jobs $newjobs
}
proc lrmdups list {
    if [lempty $list] {
        return {}
    }
    set list [lsort $list]
    set last [lvarpop list]
    lappend result $last
    foreach element $list {
        if {$last != $element} {
            lappend result $element
            set last $element
        }
    }
    return $result
}
#
# PBS variable initialization
#
# set debug flag
#
set debug 0
#
# set batch server 
#
set serv "comptel"
#
# set up maximum number of jobs for any user
#
set usermaxr 4
#
# set up load averages above which jobs won't be started
#
set max_load(ceres) "1.5"
set max_load(nova) "1.5"
set max_load(pallas) "8.0"
set max_load(juno) "1.5"
set max_load(vesta) "1.5"
set max_load(comptel) "40.0"
set clist [array names max_load]
foreach client $clist {
    if {$debug} {
	puts "Load Average Max for $client: $max_load($client)"
    }
}
#
# set number of running jobs on each client
#
set max_run(ceres) "1"
set max_run(nova) "1"
set max_run(pallas) "4"
set max_run(juno) "1"
set max_run(vesta) "1"
set max_run(comptel) "5"
#
# set up list of clients for each queue
#
set queue_hostlist(long) comptel
set queue_hostlist(long2) comptel
set queue_hostlist(comptel1) comptel
set queue_hostlist(comptel2) comptel
set queue_hostlist(comptel3) comptel
set queue_hostlist(comptel4) comptel
set queue_hostlist(nova) nova
set queue_hostlist(juno) juno
set queue_hostlist(ceres) ceres
set queue_hostlist(burst) juno
set queue_hostlist(pallas1) pallas
set queue_hostlist(pallas2) pallas
set queue_hostlist(pallas3) pallas
set queue_hostlist(pallas4) pallas
set queue_hostlist(vesta) vesta

