/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * job_attr_def is the array of attribute definitions for jobs.
 * Each legal job attribute is defined here.
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include "pbs_ifl.h" 
#include "list_link.h" 
#include "attribute.h" 
#include "server_limits.h"

static char ident[] = "@(#) $RCSfile: job_attr_def.c,v $ $Revision: 2.1 $";

/* Extern functions (at_action) called */

extern int job_set_wait A_((attribute *, void *, int));
extern int action_resc A_((attribute *pattr, void *pobject, int actmode));
extern int ck_chkpnt A_((attribute *pattr, void *pobject, int actmode));
extern int depend_on_que A_((attribute *, void *, int));
extern int comp_chkpnt A_((attribute *, attribute *));

#define ATR_DFLAG_SSET  (ATR_DFLAG_SvWR | ATR_DFLAG_SvRD)

/*
 * The entries for each attribute are (see attribute.h):
 *	name,
 *	decode function,
 *	encode function,
 *	set function,
 *	compare function,
 *	free value space function,
 *	action function,
 *	access permission flags,
 *	value type,
 *	parent object type
 */

attribute_def job_attr_def[] = {

/* JOB_ATR_jobname */
    {	ATTR_N,			/* "Job_Name" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_job_owner */
    {	ATTR_owner,		/* "Job_Owner" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SSET | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_resc_used */
    {	ATTR_used,		/* "Resources_Used" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SvWR,
	ATR_TYPE_RESC,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_state */
    {	ATTR_state,		/* "job_state" */
	decode_c,
	encode_c,
	set_c,
	comp_c,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_CHAR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_in_queue */
    {	ATTR_queue,		/* "Queue" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_at_server */
    {	ATTR_server,		/* "Server" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_account */
    {	ATTR_A,			/* "Account_Name" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_chkpnt */
    {	ATTR_c,			/* "Checkpoint" */
	decode_str,
	encode_str,
	set_str,
#ifdef PBS_MOM	
	comp_str,
#else	/* PBS_MOM - server side */
	comp_chkpnt,
#endif	/* PBS_MOM */
	free_str,
#ifdef PBS_MOM	
	NULL_FUNC,
#else	/* PBS_MOM - server side */
	ck_chkpnt,
#endif	/* PBS_MOM */
	READ_WRITE | ATR_DFLAG_MOM | ATR_DFLAG_ALTRUN,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_ctime */
    {	ATTR_ctime,		/* "ctime" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SSET,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_depend */
    {	ATTR_depend,			/* "depend" */
#ifndef PBS_MOM
	decode_depend,
	encode_depend,
	set_depend,
	comp_depend,
	free_depend,
	depend_on_que,
#else
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,	
#endif	/* PBS_MOM */
	READ_WRITE,
	ATR_TYPE_LIST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_errpath */
    {	ATTR_e,			/* "Error_Path" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_exec_host */
    {	ATTR_exechost,		/* "exec_host" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_exectime */
    {	ATTR_a,			/* "Execution_Time" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
#ifndef PBS_MOM
	job_set_wait,
#else
	NULL_FUNC,
#endif
	READ_WRITE | ATR_DFLAG_ALTRUN,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_grouplst */
    {	ATTR_g,			/* "group_list" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_hold */
    {	ATTR_h,			/* "Hold_Types" */
	decode_hold,
	encode_hold,
	set_b,
	comp_hold,
	free_null,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_interactive */
    {	ATTR_inter,		/* "interactive" */
	decode_l,
	encode_inter,
	set_l,
	comp_b,
	free_null,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SvRD | ATR_DFLAG_Creat | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_join */
    {	ATTR_j,			/* "Join_Path" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_keep */
    {	ATTR_k,			/* "Keep_Files" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_mailpnts */
    {	ATTR_m,			/* "Mail_Points" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_mailuser */
    {	ATTR_M,			/* "Mail_Users" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_mtime */
    {	ATTR_mtime,		/* "mtime" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SSET,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_output */
    {	ATTR_o,			/* "Output_Path" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_priority */
   {	ATTR_p,			/* "Priority" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_qtime */
    {	"qtime",		/* "qtime"  (time entered queue) */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_rerunable */
    {	ATTR_r,			/* "Rerunable" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_resource */
    {	ATTR_l,			/* "Resource_List" */
	decode_resc,	
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	action_resc,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_MOM,
	ATR_TYPE_RESC,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_session_id */
    {	ATTR_session,		/* "session_id" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SvWR,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_shell */
    {	ATTR_S,			/* "Shell_Path_List" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_ALTRUN | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_stagein */
    {	ATTR_stagein,		/* "stagein" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_stageout */
    {	ATTR_stageout,		/* "stageout" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_substate */
    {	ATTR_substate,		/* "substate" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	ATR_DFLAG_OPRD | ATR_DFLAG_MGRD,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_userlst */
    {	ATTR_u,			/* "User_List" */
	decode_arst,
	encode_arst,
#ifndef PBS_MOM
	set_uacl,
#else
	set_arst,
#endif
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_variables */
    {	ATTR_v,			/* "Variable_List" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ | ATR_DFLAG_MOM,
	ATR_TYPE_ARST,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_euser    */
    {	ATTR_euser,		/* "euser" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	ATR_DFLAG_MGRD | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_egroup  */
    {	ATTR_egroup,		/* "egroup" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	ATR_DFLAG_MGRD | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_hashname */
    {	ATTR_hashname,		/* "hashname" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	ATR_DFLAG_MGRD | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_hopcount */
    {	ATTR_hopcount,		/* "hop_count" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	ATR_DFLAG_SSET,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_queuerank */
    {	ATTR_qrank,		/* "queue_rank" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	ATR_DFLAG_MGRD,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_queuetype */
    {	ATTR_qtype,		/*"queue_type" - exists for Scheduler select */
	decode_c,
	encode_c,
	set_c,
	comp_c,
	free_null,
	NULL_FUNC,
	ATR_DFLAG_MGRD | ATR_DFLAG_SELEQ,
	ATR_TYPE_CHAR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_sched_hint */
    {	ATTR_sched_hint,	/* "sched_hint" - inform scheduler re sync */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	ATR_DFLAG_MGRD | ATR_DFLAG_MGWR,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_security */
    {	ATTR_security,		/* "security" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	ATR_DFLAG_SSET,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_Comment */
    {	ATTR_comment,		/* "comment" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	NO_USER_SET | ATR_DFLAG_SvWR | ATR_DFLAG_ALTRUN,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_Cookie */
    {	ATTR_cookie,		/* "cookie" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	ATR_DFLAG_SvRD | ATR_DFLAG_SvWR | ATR_DFLAG_MOM,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_altid */
    {	ATTR_altid,		/* "alt_id" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SvWR,
	ATR_TYPE_STR,
	PARENT_TYPE_JOB
    },
/* JOB_ATR_etime */
    {	ATTR_etime,		/* "etime" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY | ATR_DFLAG_SSET,
	ATR_TYPE_LONG,
	PARENT_TYPE_JOB
    },
	
/* Site defined attributes if any, see site_job_attr_*.h  */
#include "site_job_attr_def.h"

/* JOB_ATR_UNKN - THIS MUST BE THE LAST ENTRY */
    {	"_other_",
	decode_unkn,
	encode_unkn,
	set_unkn,
	comp_unkn,
	free_unkn,
	NULL_FUNC,
	READ_WRITE | ATR_DFLAG_SELEQ,
	ATR_TYPE_LIST,
	PARENT_TYPE_JOB
    }
};
