/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * que_atrall_def is the array of attribute defs common to all queue types.
 * que_atrexec_def  is the array of attribute defs special to execution queues.
 * qu_attr_rt  is the array of attribute defs special to routing queues.
 *
 * Each legal queue attribute is defined here.
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include "pbs_ifl.h" 
#include "list_link.h" 
#include "attribute.h" 
#include "svrfunc.h"

extern int decode_null A_((attribute *patr, char *name, char *rn, char *val));
extern int set_null A_((attribute *patr, attribute *new, enum batch_op op));

static char ident[] = "@(#) $RCSfile: queue_attr_def.c,v $ $Revision: 2.1 $";

/*
 * The entries for each attribute are (see attribute.h):
 *	name,
 *	decode function,
 *	encode function,
 *	set function,
 *	compare function,
 *	free value space function,
 *	action function,
 *	access permission flags,
 *	value type
 */

 /* for all queues */

attribute_def que_attr_def[] = {

/* QA_ATR_QType */
    {	ATTR_qtype,		/* "queue_type"	- type of queue */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	set_queue_type,
	NO_USER_SET,
	ATR_TYPE_STR,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_Priority */		/* priority of queue releative to others */
    {	ATTR_p,			/* "priority" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_MaxJobs */		/* max number of jobs allowed in queue */
    {	ATTR_maxque,		/* "max_queuable" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QS_ATR_TotalJobs */		/* current number of jobs in queue */
    {	ATTR_total,		/* "total_jobs" */
	decode_null,
	encode_l,
	set_null,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_JobsByState */	/* current number of jobs in queue by state */
    {	ATTR_count,		/* "state_count" */
	decode_null,		/* note-use fixed memory in queue struct    */
	encode_str,
	set_null,
	comp_str,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_STR,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_MaxRun */		/* max number of jobs allowed to run */
    {	ATTR_maxrun,		/* "max_running" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_AclHostEnabled */	/* Host ACL to be used */
    {	ATTR_aclhten,		/* "acl_host_enable" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_AclHost */		/* Host Access Control List */
    {	ATTR_aclhost,		/* "acl_hosts" */
	decode_arst,
	encode_arst,
	set_hostacl,
	comp_arst,
	free_arst,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_AclUserEnabled */	/* User ACL to be used */
    {	ATTR_acluren,		/* "acl_user_enable" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_AclUsers */		/* User Acess Control List */
    {	ATTR_acluser,		/* "acl_users" */
	decode_arst,
	encode_arst,
	set_uacl,
	comp_arst,
	free_arst,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_FromRouteOnly */	/* Jobs can only enter from a routing queue */
    {	ATTR_fromroute,		/* "from_route_only" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_ResourceMax */
    {	ATTR_rescmax,		/* "resources_max" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_ResourceMin */
    {	ATTR_rescmin,		/* "resources_min" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_ResourceDefault */
    {	ATTR_rescdflt,		/* "resources_default" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_QUE_ALL
    },

    /* for execution queues only */

/* QE_ATR_AclGroupEnabled */	/* Group ACL to be used */
    {	ATTR_aclgren,		/* "acl_group_enable" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_AclGroup */		/* Group Access Control List */
    {	ATTR_aclgroup,		/* "acl_group_list" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_ChkptMin */
    {	ATTR_chkptmin,		/* "checkpoint_min" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_RendezvousRetry */	/* Number times to retry sync of jobs */
    {	"rendezvous_retry",
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_ReservedExpedite */
    {	"reserved_expedite",
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_ReservedSync */
    {	"reserved_sync",
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_ResourceAvail */
    {	"resources_available",
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_ResourceAssn */
    {	ATTR_rescassn,		/* "resources_assigned" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_RESC,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_KillDelay */
    {	ATTR_killdelay,		/* "kill_delay" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_MaxUserRun */
    {	ATTR_maxuserrun,	/* "max_user_run" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },
/* QE_ATR_MaxGrpRun */
    {	ATTR_maxgrprun,		/* "max_group_run" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_EXC
    },

    /* for routing queues */

/* QR_ATR_RouteDestin */
    {	ATTR_routedest,		/* "route_destinations" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_arst,
	free_arst,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_ARST,
	PARENT_TYPE_QUE_RTE
    },
/* QR_ATR_AltRouter */
    {	ATTR_altrouter,		/* "alt_router" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_RTE
    },
/* QR_ATR_RouteHeld */
    {	ATTR_routeheld,		/* "route_held_jobs" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_RTE
    },
/* QR_ATR_RouteWaiting */
    {	ATTR_routewait,		/* "route_waiting_jobs" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_RTE
    },
/* QR_ATR_RouteRetryTime */
    {	ATTR_routeretry,	/* "route_retry_time" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_RTE
    },
/* QR_ATR_RouteLifeTime	 */
    {	ATTR_routelife,		/* "route_lifetime" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_RTE
    },
/* site supplied attribute definitions, if any, see site_que_attr_*.h	*/
#include "site_que_attr_def.h"

/* QA_ATR_Enabled */		/* Queue enabled - jobs can be enqueued */
    {	ATTR_enable,		/* "enabled" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	check_que_enable,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    },
/* QA_ATR_Started */		/* Queue enabled - jobs can be started */
    {	ATTR_start,		/* "started" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_QUE_ALL
    }
};
