/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * req_getcred.c
 *
 * This file contains function relating to the PBS credential system,
 * it includes the major functions:
 *   req_authenuser - Authenticate a user connection based on pbs_iff  (new)
 *   req_connect    - validate the credential in a Connection Request (old)
 */
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include "libpbs.h"
#include "server_limits.h"
#include "list_link.h"
#include "attribute.h"
#include "credential.h"
#include "net_connect.h"
#include "batch_request.h"

static char ident[] = "@(#) $RCSfile: req_getcred.c,v $ $Revision: 2.1 $";

/* External Global Data Items Referenced */

extern time_t time_now;
extern struct connection svr_conn[];

/* Global Data Home in this file */

struct credential conn_credent[PBS_NET_MAX_CONNECTIONS];
	/* there is one per possible connectinn */

/*
 * req_connect - process a Connection Request
 * 	Almost does nothing.
 */

void req_connect(preq)
	struct batch_request *preq;
{
	int  sock = preq->rq_conn;

	if (svr_conn[sock].cn_authen == 0) {
		reply_ack(preq);
	} else
		req_reject(PBSE_BADCRED, 0, preq);
}

/*
 * req_authenuser - Authenticate a user connection based on the (new)
 *	pbs_iff information.  Pbs_iff will contact the server on a privileged
 *	port and identify the user who has made an existing, but yet unused,
 *	non-privileged connection.  This connection is marked as authenticated.
 */

void req_authenuser(preq)
	struct batch_request *preq;
{
	int s;

	/*
	 * find the socket whose client side is bound to the port named 
	 * in the request
	 */

	for (s=0; s<PBS_NET_MAX_CONNECTIONS; ++s) {
	    if (preq->rq_ind.rq_authen.rq_port == svr_conn[s].cn_port) {
		if (svr_conn[s].cn_authen == 0) {
			
		    (void)strcpy(conn_credent[s].username, preq->rq_user);
		    (void)strcpy(conn_credent[s].hostname, preq->rq_host);
		    /* time stamp just for the record */
		    conn_credent[s].timestamp = time_now;
		    svr_conn[s].cn_authen = PBS_NET_CONN_AUTHENTICATED;
		}
		reply_ack(preq);
		return;
	    }
	}
	req_reject(PBSE_BADCRED, 0, preq);
}
