/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * svr_locate.c 
 *
 * Functions relating to the Locate Job Batch Request.
 *
 * Included funtions are:
 *	
 *
 */
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include "libpbs.h"
#include <signal.h>
#include <string.h>
#include "server_limits.h"
#include "list_link.h"
#include "attribute.h"
#include "server.h"
#include "credential.h"
#include "batch_request.h"
#include "job.h"
#include "work_task.h"
#include "tracking.h"
#include "pbs_error.h"
#include "log.h"

static char ident[] = "@(#) $RCSfile: req_locate.c,v $ $Revision: 2.1 $";

/* Global Data Items: */

extern struct server server;
extern char   server_name[];

/*
 * req_locatejob - service the Locate Job Request
 *
 *	This request attempts to locate a job.
 */

void req_locatejob(preq)
	struct batch_request *preq;
{
	char 		 *at;
	int		  i;
	job		 *pjob;
	char		 *location = (char *)0;

	if (at = strchr(preq->rq_ind.rq_locate, (int)'@'))
	    *at = '\0';			/* strip off @server_name */
	pjob = find_job(preq->rq_ind.rq_locate);
	if (pjob) {
	    location = server_name;
	} else {
	    for (i=0; i < server.sv_tracksize; i++) {
		if ((server.sv_track+i)->tk_mtime &&
		    !strcmp((server.sv_track+i)->tk_jobid, preq->rq_ind.rq_locate)) {
			location = (server.sv_track+i)->tk_location;
			break;
		}
	    }
	}
	if (location) {
		preq->rq_reply.brp_code = 0;
		preq->rq_reply.brp_auxcode = 0;
		preq->rq_reply.brp_choice = BATCH_REPLY_CHOICE_Locate;
		(void)strcpy(preq->rq_reply.brp_un.brp_locate, location);
		reply_send(preq);
	} else 
		req_reject(PBSE_UNKJOBID, 0, preq);
	return;
}
