/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include "portability.h"
#include "list_link.h"
#include "attribute.h"
#include "server_limits.h"
#include "job.h"

void
prt_job_struct(pjob)
	job *pjob;
{
	printf("---------------------------------------------------\n");
	printf("jobid:\t%s\n", pjob->ji_qs.ji_jobid);
	printf("---------------------------------------------------\n");
	printf("state:\t\t0x%x\n", pjob->ji_qs.ji_state);
	printf("substate:\t0x%x (%d)\n", pjob->ji_qs.ji_substate,
					pjob->ji_qs.ji_substate);
	printf("svrflgs:\t0x%x (%d)\n", pjob->ji_qs.ji_svrflags,
					pjob->ji_qs.ji_svrflags);
	printf("ordering:\t%d\n", pjob->ji_qs.ji_ordering);
	printf("inter prior:\t%d\n", pjob->ji_qs.ji_priority);
	printf("stime:\t\t%d\n", pjob->ji_qs.ji_stime);
	printf("file base:\t%s\n", pjob->ji_qs.ji_fileprefix);
	printf("queue:\t\t%s\n", pjob->ji_qs.ji_queue);
	switch (pjob->ji_qs.ji_un_type) {
	    case JOB_UNION_TYPE_NEW:
		printf("union type new:\n");
		printf("\tsocket\t%d\n", pjob->ji_qs.ji_un.ji_newt.ji_fromsock);
		printf("\taddr\t%lu\n", pjob->ji_qs.ji_un.ji_newt.ji_fromaddr);
		printf("\tscript\t%d\n", pjob->ji_qs.ji_un.ji_newt.ji_scriptsz);
		break;
	    case JOB_UNION_TYPE_EXEC:
		printf("union type exec:\n");
		printf("\tmomaddr\t%lu\n",pjob->ji_qs.ji_un.ji_exect.ji_momaddr);
		printf("\texits\t%d\n",pjob->ji_qs.ji_un.ji_exect.ji_exitstat);
		break;
	    case JOB_UNION_TYPE_ROUTE:
		printf("union type route:\n");
		printf("\tquetime\t%d\n",pjob->ji_qs.ji_un.ji_routet.ji_quetime);
		printf("\tretry\t%d\n", pjob->ji_qs.ji_un.ji_routet.ji_rteretry);
		break;
	    case JOB_UNION_TYPE_MOM:
		printf("union type mom:\n");
		printf("\tsvraddr\t%lu\n", pjob->ji_qs.ji_un.ji_momt.ji_svraddr);
		printf("\texitst\t%d\n", pjob->ji_qs.ji_un.ji_momt.ji_exitstat);
		printf("\tuid\t%d\n", pjob->ji_qs.ji_un.ji_momt.ji_exuid);
		printf("\tgid\t%d\n", pjob->ji_qs.ji_un.ji_momt.ji_exgid);
		break;
	    default:
		printf("--bad union type %d\n", pjob->ji_qs.ji_un_type);
	}
}

#define ENDATTRIBUTES -711

int read_attr(fd)
	int fd;
{
	int	  amt;
	int       i;
	svrattrl *pal;
	svrattrl  tempal;

	i = read(fd, (char *)&tempal, sizeof (tempal));
	if (i != sizeof (tempal)) {
		fprintf(stderr, "bad read of attribute\n");
		return 0;
	}
	if (tempal.al_tsize == ENDATTRIBUTES)
		return 0;

	pal = (svrattrl *)malloc(tempal.al_tsize);
	if (pal == (svrattrl *)0) {
		fprintf(stderr, "malloc failed\n");
		exit(1);
	}
	*pal = tempal;

	/* read in the actual attribute data */

	amt = pal->al_tsize - sizeof (svrattrl);
	i = read(fd, (char *)pal + sizeof (svrattrl), amt);
	if (i != amt) {
		fprintf(stderr, "short read of attribute\n");
		exit(2);
	}
	pal->al_name = (char *)pal + sizeof (svrattrl);
	if (pal->al_rescln)
		pal->al_resc = pal->al_name + pal->al_nameln;
	else
		pal->al_resc = (char *)0;
	if (pal->al_valln)
		pal->al_value = pal->al_name + pal->al_nameln + pal->al_rescln;
	else
		pal->al_value = (char *)0;

	printf("%s", pal->al_name);
	if (pal->al_resc)
		printf(".%s", pal->al_resc);
	printf(" = ");
	if (pal->al_value)
		printf("%s", pal->al_value);
	printf("\n");

	free(pal);
	return 1;
}

main(argc, argv)
	int argc;
	char *argv[];
{
	int amt;
	int err = 0;
	int f;
	int fp;
	int no_attributes = 0;
	svrattrl *psvrat;
	job xjob;
	extern int optind;

	while ((f = getopt(argc, argv, "a")) != EOF) {

	    switch (f) {
		case 'a':
			no_attributes = 1;
			break;

		default: err = 1;
	    }
	}
	if (err || (argc - optind < 1)) {
		fprintf(stderr, "usage: %s [-a] file [file ...}\n", argv[0]);
		return 1;
	}

	for (f=optind; f<argc; ++f) {
		fp = open(argv[f], O_RDONLY, 0);
		if (fp < 0) {
			perror("open failed");
			fprintf(stderr, "unable to open file %s\n", argv[f]);
			exit(1);
		}
		amt = read(fp, &xjob.ji_qs, sizeof(xjob.ji_qs));
		if (amt != sizeof(xjob.ji_qs)) {
			fprintf(stderr, "Short read of %d bytes, file %s\n",
				amt, argv[f]);
		}
		/* print out job structure */

		prt_job_struct(&xjob);

		/* now do attributes, one at a time */

		if (no_attributes == 0) {
			printf("--attributes--\n");
			while (read_attr(fp)) ;
		}

		(void)close(fp);
		printf("\n");
	}
	return (0);
}
