/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import plugin.charactersheet.gui.CharacterPanel;

public class CharacterSheetModel {
    private JTabbedPane masterPane = new JTabbedPane();
    private ArrayList characters = new ArrayList();
    private ArrayList infoPanes = new ArrayList();

    public CharacterSheetModel() {
        this.masterPane.setTabPlacement(3);
        this.masterPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CharacterSheetModel.this.refresh();
            }
        });
        this.applyPrefs();
    }

    public Component getComponent() {
        return this.masterPane;
    }

    public Component getCharacterComponent() {
        CharacterPanel cp = new CharacterPanel();
        this.infoPanes.add(new WeakReference<CharacterPanel>(cp));
        return cp;
    }

    public void addPc(PlayerCharacter pc) {
        this.characters.add(pc);
        CharacterPanel pcPanel = new CharacterPanel();
        pcPanel.setPc(pc);
        this.masterPane.add(pc.getDisplayName(), pcPanel);
    }

    public void removePc(PlayerCharacter pc) {
        this.characters.remove(pc);
        for (int i = 0; i < this.masterPane.getTabCount(); ++i) {
            CharacterPanel cp;
            Component testPanel = this.masterPane.getComponent(i);
            if (!(testPanel instanceof CharacterPanel) || (cp = (CharacterPanel)testPanel).getPc() != pc) continue;
            cp.flushPrefs();
            this.masterPane.remove(cp);
            break;
        }
    }

    public void savePc(PlayerCharacter pc) {
        this.characters.remove(pc);
        for (int i = 0; i < this.masterPane.getTabCount(); ++i) {
            CharacterPanel cp;
            Component testPanel = this.masterPane.getComponent(i);
            if (!(testPanel instanceof CharacterPanel) || (cp = (CharacterPanel)testPanel).getPc() != pc) continue;
            cp.save();
            break;
        }
    }

    public void refresh() {
        Component testPanel = this.masterPane.getSelectedComponent();
        if (testPanel instanceof CharacterPanel) {
            ((CharacterPanel)testPanel).refresh();
        }
    }

    public void closeWindow() {
        for (int i = 0; i < this.masterPane.getTabCount(); ++i) {
            Component testPanel = this.masterPane.getComponent(i);
            if (!(testPanel instanceof CharacterPanel)) continue;
            CharacterPanel cp = (CharacterPanel)testPanel;
            cp.flushPrefs();
            break;
        }
    }

    public void applyPrefs() {
        CharacterPanel cp;
        int i;
        int value = SettingsHandler.getGMGenOption((String)"CharacterSheet.color", (int)0);
        switch (value) {
            case 0: {
                CharacterPanel.setColorBlue();
                break;
            }
            case 1: {
                CharacterPanel.setColorLightBlue();
                break;
            }
            case 2: {
                CharacterPanel.setColorGreen();
                break;
            }
            case 3: {
                CharacterPanel.setColorLightGreen();
                break;
            }
            case 4: {
                CharacterPanel.setColorRed();
                break;
            }
            case 5: {
                CharacterPanel.setColorLightRed();
                break;
            }
            case 6: {
                CharacterPanel.setColorYellow();
                break;
            }
            case 7: {
                CharacterPanel.setColorLightYellow();
                break;
            }
            case 8: {
                CharacterPanel.setColorGrey();
                break;
            }
            case 9: {
                CharacterPanel.setColorLightGrey();
                break;
            }
            default: {
                CharacterPanel.setColorBlue();
            }
        }
        for (i = 0; i < this.masterPane.getTabCount(); ++i) {
            Component testPanel = this.masterPane.getComponent(i);
            if (!(testPanel instanceof CharacterPanel)) continue;
            cp = (CharacterPanel)testPanel;
            cp.setColor();
        }
        for (i = 0; i < this.infoPanes.size(); ++i) {
            WeakReference wr = (WeakReference)this.infoPanes.get(i);
            cp = (CharacterPanel)wr.get();
            cp.setColor();
        }
    }
}

