/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.PCClosedMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.SavePCGNotificationMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.gui.PCGen_Frame1;
import plugin.charactersheet.CharacterSheetModel;
import plugin.charactersheet.gui.PreferencesDisplayPanel;

public class CharacterSheetPlugin
extends GMBPlugin {
    private static final String CS_TOOLS_COMMAND = "TOOLS_MENU_ENTRY";
    public static final String LOG_NAME = "CharacterSheet";
    private JMenuItem csToolsItem = new JMenuItem();
    private String name = "Character Sheet";
    private String version = "00.00.00.01";
    private CharacterSheetModel model;

    public void start() {
        this.model = new CharacterSheetModel();
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesDisplayPanel(this.model)));
        if (this.getPluginSystem() == "PCGen") {
            GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.model.getCharacterComponent(), this.getPluginSystem()));
        } else {
            GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.model.getComponent(), this.getPluginSystem()));
        }
        this.initMenus();
    }

    public FileFilter[] getFileTypes() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"CharacterSheet.System", (String)"PCGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"CharacterSheet.LoadOrder", (int)10);
    }

    public void handleMessage(GMBMessage message) {
        if (this.getPluginSystem() == "GMGen") {
            if (message instanceof StateChangedMessage) {
                this.handleStateChangedMessage((StateChangedMessage)message);
            } else if (message instanceof PCLoadedMessage) {
                this.handlePCLoadedMessage((PCLoadedMessage)message);
            } else if (message instanceof PCClosedMessage) {
                this.handlePCClosedMessage((PCClosedMessage)message);
            } else if (message instanceof SavePCGNotificationMessage) {
                this.handleSavePCGNotificationMessage((SavePCGNotificationMessage)message);
            } else if (message instanceof WindowClosedMessage) {
                this.handleWindowClosedMessage((WindowClosedMessage)message);
            }
        }
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!tp.getComponentAt(i).equals(this.model.getComponent())) continue;
            tp.setSelectedIndex(i);
        }
    }

    private void handleStateChangedMessage(StateChangedMessage message) {
        StateChangedMessage smessage = message;
        if (this.getPluginSystem().equals("PCGen")) {
            if (PCGen_Frame1.getBaseTabbedPane().getSelectedComponent().equals(this.model.getComponent())) {
                this.model.refresh();
            }
        } else if (GMGenSystemView.getTabPane().getSelectedComponent().equals(this.model.getComponent()) && GMGenSystem.inst.isFocused()) {
            this.csToolsItem.setEnabled(false);
            this.model.refresh();
        } else {
            this.csToolsItem.setEnabled(true);
        }
    }

    public void handlePCLoadedMessage(PCLoadedMessage message) {
        if (!message.isIgnored((GMBComponent)this)) {
            this.model.addPc(message.getPC());
        }
    }

    public void handlePCClosedMessage(PCClosedMessage message) {
        this.model.removePc(message.getPC());
    }

    public void handleSavePCGNotificationMessage(SavePCGNotificationMessage message) {
        this.model.savePc(message.getPC());
    }

    public void handleWindowClosedMessage(WindowClosedMessage message) {
        this.model.closeWindow();
    }

    public void initMenus() {
        this.csToolsItem.setMnemonic('S');
        this.csToolsItem.setText("Character Sheet");
        this.csToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterSheetPlugin.this.toolMenuItem(evt);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.csToolsItem));
    }
}

