/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CharacterSheetUtils {
    public static void addGbCell(Container cont, String text, int gridX, int gridY, int gridHeight, int gridWidth, int fill, int anchor, int layout, Color color) {
        CharacterSheetUtils.addGbCell(cont, text, gridX, gridY, gridHeight, gridWidth, fill, anchor, layout, color, null);
    }

    public static void addGbCell(Container cont, String text, int gridX, int gridY, int gridHeight, int gridWidth, int fill, int anchor, int layout, Color color, List componentList) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel cell = new JPanel();
        JLabel cellText = new JLabel();
        cell.setLayout(new FlowLayout(layout, 1, 0));
        cell.setBackground(color);
        cellText.setFont(new Font("Dialog", 0, 10));
        cellText.setText(text);
        cell.add(cellText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridX;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.gridwidth = gridHeight;
        gridBagConstraints.gridwidth = gridWidth;
        gridBagConstraints.fill = fill;
        gridBagConstraints.anchor = anchor;
        cont.add((Component)cell, gridBagConstraints);
        if (componentList != null) {
            componentList.add(cell);
        }
    }

    public static void addGbComponentCell(Container cont, Component comp, int gridX, int gridY, int gridHeight, int gridWidth, Insets insets, int fill, int anchor) {
        CharacterSheetUtils.addGbComponentCell(cont, comp, gridX, gridY, gridHeight, gridWidth, insets, fill, anchor, null);
    }

    public static void addGbComponentCell(Container cont, Component comp, int gridX, int gridY, int gridHeight, int gridWidth, Insets insets, int fill, int anchor, List componentList) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridX;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.gridheight = gridHeight;
        gridBagConstraints.gridwidth = gridWidth;
        gridBagConstraints.fill = fill;
        gridBagConstraints.anchor = anchor;
        gridBagConstraints.insets = insets;
        cont.add(comp, gridBagConstraints);
        if (componentList != null) {
            componentList.add(comp);
        }
    }

    public static String getTitle(String fullTitle) {
        return CharacterSheetUtils.getTitle(fullTitle, "", "");
    }

    public static String getTitle(String fullTitle, String pre, String post) {
        if (fullTitle.indexOf("(") > -1) {
            return pre + fullTitle.substring(0, fullTitle.indexOf("(")).trim() + post;
        }
        return pre + fullTitle.toString() + post;
    }

    public static String getSubTitle(String fullTitle) {
        return CharacterSheetUtils.getSubTitle(fullTitle, "", "");
    }

    public static String getSubTitle(String fullTitle, String pre, String post) {
        if (fullTitle.indexOf("(") > -1) {
            return pre + fullTitle.substring(fullTitle.indexOf("(")).trim() + post;
        }
        return "";
    }
}

