/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.plugin.PlayerCharacterOutput;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import plugin.charactersheet.gui.CharacterPanel;

public class ArmorPane
extends JPanel {
    private PlayerCharacter pc;
    private int index = 0;
    private ArrayList fields = new ArrayList();
    private JTextArea sprops = new JTextArea();
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel11;
    private JPanel jPanel17;
    private JPanel jPanel20;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel9;
    private JLabel typeName;

    public ArmorPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.typeName = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel20 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jPanel17 = new JPanel();
        this.jLabel7 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new FlowLayout(1, 1, 0));
        this.typeName.setFont(new Font("Dialog", 0, 10));
        this.typeName.setText(" ARMOR ");
        this.jPanel5.add(this.typeName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel5.setFont(new Font("Dialog", 0, 10));
        this.jLabel5.setText(" Type ");
        this.jPanel6.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel9.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel6.setFont(new Font("Dialog", 0, 10));
        this.jLabel6.setText(" AC ");
        this.jPanel9.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel11.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel4.setFont(new Font("Dialog", 0, 10));
        this.jLabel4.setText(" Max Dex ");
        this.jPanel11.add(this.jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel20.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel8.setFont(new Font("Dialog", 0, 10));
        this.jLabel8.setText(" Check ");
        this.jPanel20.add(this.jLabel8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel20, gridBagConstraints);
        this.jPanel17.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel7.setFont(new Font("Dialog", 0, 10));
        this.jLabel7.setText(" Spell Failure ");
        this.jPanel17.add(this.jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel17, gridBagConstraints);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.border);
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
        this.jPanel9.setBackground(CharacterPanel.header);
        this.jPanel11.setBackground(CharacterPanel.header);
        this.jPanel20.setBackground(CharacterPanel.header);
        this.jPanel17.setBackground(CharacterPanel.header);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel5.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel6.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel9.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel11.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel20.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel17.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter pc, String type) {
        this.pc = pc;
        this.typeName.setText(type);
    }

    public void refresh() {
        PlayerCharacterOutput pcOut = new PlayerCharacterOutput(this.pc);
        String armorType = this.typeName.getText();
        for (int i = 0; i < this.fields.size(); ++i) {
            this.remove((Component)this.fields.get(i));
        }
        this.fields.clear();
        List armorList = this.getArmorList();
        if (armorList.size() == 0) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            boolean gridX = false;
            int gridY = 1;
            for (int i = 0; i < armorList.size(); ++i) {
                Equipment eq = (Equipment)armorList.get(i);
                this.addField(0, gridY, pcOut.getExportToken("ARMOR." + armorType + "." + i + ".NAME"));
                this.addField(1, gridY, pcOut.getExportToken("ARMOR." + armorType + "." + i + ".TYPE"));
                this.addField(2, gridY, pcOut.getExportToken("ARMOR." + armorType + "." + i + ".ACBONUS"));
                this.addField(3, gridY, pcOut.getExportToken("ARMOR." + armorType + "." + i + ".MAXDEX"));
                this.addField(4, gridY, pcOut.getExportToken("ARMOR." + armorType + "." + i + ".ACCHECK"));
                this.addField(5, gridY, pcOut.getExportToken("ARMOR." + armorType + "." + i + ".SPELLFAIL"));
                String sprops = pcOut.getExportToken("ARMOR." + armorType + "." + i + ".SPROPS");
                if (!sprops.equals("")) {
                    this.addSprops(++gridY, sprops);
                }
                ++gridY;
            }
        }
    }

    private List getArmorList() {
        List<Equipment> armorList = new ArrayList();
        String armorType = this.typeName.getText();
        if (armorType.equals("ARMOR")) {
            armorList = this.pc.getEquipmentOfTypeInOutputOrder("ARMOR", 3);
        } else if (armorType.equals("SHIELD")) {
            armorList = this.pc.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
        } else if (armorType.equals("ITEM")) {
            Iterator e = this.pc.getEquipmentListInOutputOrder().iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                if (!eq.getBonusListString("AC") || eq.isArmor() || eq.isShield()) continue;
                armorList.add(eq);
            }
        }
        return armorList;
    }

    private void addField(int gridx, int gridy, String text) {
        JPanel field = new JPanel();
        JLabel data = new JLabel();
        field.setBackground(CharacterPanel.bodyLight);
        field.setLayout(new FlowLayout(1, 1, 0));
        data.setFont(new Font("Dialog", 0, 10));
        if (text.equals("")) {
            text = " ";
        }
        data.setText(text);
        field.add(data);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        this.add((Component)field, gridBagConstraints);
        this.fields.add(field);
    }

    private void addSprops(int gridY, String text) {
        this.sprops.setFont(new Font("Dialog", 0, 10));
        this.sprops.setLineWrap(true);
        this.sprops.setWrapStyleWord(true);
        this.sprops.setText(text);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.sprops, gridBagConstraints);
        this.fields.add(this.sprops);
    }
}

