/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.ScrollablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.Globals;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import plugin.charactersheet.gui.NotesPanel;
import plugin.charactersheet.gui.Page1Panel;
import plugin.charactersheet.gui.Page2Panel;
import plugin.charactersheet.gui.SpellPage;

public class CharacterPanel
extends JSplitPane
implements CharacterInfoTab {
    private PlayerCharacter pc;
    private Page1Panel page1;
    private Page2Panel page2;
    private ScrollablePanel page1layout;
    private ScrollablePanel page2layout;
    private List spellPaneList;
    private NotesPanel notesPanel;
    private Properties pcProperties;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private static final int BIO_NOTEID = -2;
    private static final int DESCRIPTION_NOTEID = -3;
    private static final int COMPANION_NOTEID = -4;
    private static final int OTHERASSETS_NOTEID = -5;
    private static final int MAGICITEMS_NOTEID = -6;
    public static final int BLUE = 0;
    public static final int LIGHTBLUE = 1;
    public static final int GREEN = 2;
    public static final int LIGHTGREEN = 3;
    public static final int RED = 4;
    public static final int LIGHTRED = 5;
    public static final int YELLOW = 6;
    public static final int LIGHTYELLOW = 7;
    public static final int GREY = 8;
    public static final int LIGHTGREY = 9;
    public static Color black = new Color(0, 0, 0);
    public static Color darkGrey = new Color(102, 102, 102);
    public static Color lightGrey = new Color(204, 204, 204);
    public static Color white = new Color(255, 255, 255);
    public static Color border = new Color(85, 85, 136);
    public static Color header = new Color(153, 153, 187);
    public static Color bodyDark = new Color(170, 170, 204);
    public static Color bodyMedDark = new Color(187, 187, 238);
    public static Color bodyMedLight = new Color(204, 204, 238);
    public static Color bodyLight = new Color(238, 238, 255);
    private JTabbedPane mainTabs;

    public CharacterPanel() {
        this.initComponents();
        this.initPrefs();
    }

    public int getTabOrder() {
        return SettingsHandler.getGMGenOption((String)".Panel.CharacterPanel.Order", (int)20);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setGMGenOption((String)".Panel.CharacterPanel.Order", (int)order);
    }

    public String getTabName() {
        return "Preview";
    }

    public boolean isShown() {
        return SettingsHandler.getGMGenOption((String)".Panel.CharacterPanel.Show", (boolean)true);
    }

    public JComponent getView() {
        return this;
    }

    private void initComponents() {
        this.mainTabs = new JTabbedPane();
        this.setOneTouchExpandable(true);
        this.mainTabs.setTabPlacement(2);
        this.mainTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CharacterPanel.this.mainTabsStateChanged(evt);
            }
        });
        this.setLeftComponent(this.mainTabs);
        this.setRightComponent(new JPanel());
    }

    private void mainTabsStateChanged(ChangeEvent evt) {
        this.refresh();
    }

    private void initPrefs() {
        this.setDividerLocation(SettingsHandler.getGMGenOption((String)"CharacterSheet.DividerLocation", (int)2000));
    }

    public void flushPrefs() {
        SettingsHandler.setGMGenOption((String)"CharacterSheet.DividerLocation", (int)this.getDividerLocation());
        this.notesPanel.flushPrefs();
    }

    public void setPc(PlayerCharacter pc) {
        this.pc = pc;
        this.generateTabs(true);
        this.setColor();
        this.readyForRefresh = true;
        this.refresh();
    }

    public synchronized void generateTabs(boolean removeall) {
        if (removeall) {
            this.mainTabs.removeAll();
            this.page1 = new Page1Panel();
            this.page1layout = new ScrollablePanel(20);
            this.page2 = new Page2Panel();
            this.page2layout = new ScrollablePanel(20);
            this.spellPaneList = new ArrayList();
            this.notesPanel = new NotesPanel();
            this.pcProperties = new Properties();
            Globals.setCurrentPC((PlayerCharacter)this.pc);
            this.populatePcProperties();
            this.notesPanel.setPc(this.pc, this.pcProperties);
            this.setRightComponent(this.notesPanel);
            this.page1.setPc(this.pc, this.pcProperties);
            this.page1layout.setLayout((LayoutManager)new FlowLayout(0, 5, 5));
            this.page1layout.add((Component)this.page1);
            this.mainTabs.add("Page 1", new JScrollPane((Component)this.page1layout));
            ((JScrollPane)this.mainTabs.getSelectedComponent()).getViewport().setViewPosition(new Point(0, 0));
            this.page2.setPc(this.pc, this.pcProperties);
            this.page2layout.setLayout((LayoutManager)new FlowLayout(0, 5, 5));
            this.page2layout.add((Component)this.page2);
            this.mainTabs.add("Page 2", new JScrollPane((Component)this.page2layout));
        }
        List spellClassList = this.pc.getSpellClassList();
        for (int i = 0; i < spellClassList.size(); ++i) {
            PObject pobject = (PObject)spellClassList.get(i);
            if (!(pobject instanceof PCClass)) continue;
            PCClass pcclass = (PCClass)pobject;
            String className = pcclass.getDisplayClassName();
            for (int j = 0; j <= 9; ++j) {
                int spellList;
                int perDay = pcclass.getCastForLevel(pcclass.getLevel(), j, Globals.getDefaultSpellBook(), this.pc);
                String title = className + " " + j;
                if (perDay > 0 && this.mainTabs.indexOfTab(title) == -1 && (spellList = pcclass.getCharacterSpell(null, Globals.getDefaultSpellBook(), j).size()) > 0) {
                    SpellPage spellPage = new SpellPage(20);
                    spellPage.setPc(this.pc, this.pcProperties, pcclass, j);
                    this.mainTabs.add(title, new JScrollPane((Component)((Object)spellPage)));
                    this.spellPaneList.add(spellPage);
                    spellPage.refresh();
                }
                if (perDay != 0 || this.mainTabs.indexOfTab(title) <= -1) continue;
                this.mainTabs.remove(this.mainTabs.indexOfTab(title));
            }
        }
        List charList = this.pc.getRace().getCharacterSpellList();
        String title = this.pc.getRace().getName();
        if (charList != null && charList.size() > 0 && this.mainTabs.indexOfTab(title) == -1) {
            SpellPage spellPage = new SpellPage(20);
            spellPage.setPc(this.pc, this.pcProperties);
            this.mainTabs.add(title, new JScrollPane((Component)((Object)spellPage)));
            this.spellPaneList.add(spellPage);
            spellPage.refresh();
        }
    }

    public void refresh() {
        new Refresher().start();
    }

    public void forceRefresh() {
        this.readyForRefresh = true;
        new Refresher().start();
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    private void populatePcProperties() {
        ArrayList notesList = this.pc.getNotesList();
        for (int i = 0; i < notesList.size(); ++i) {
            NoteItem note = (NoteItem)notesList.get(i);
            if (!note.getName().equals("Hidden")) continue;
            try {
                this.pcProperties.load(new ByteArrayInputStream(note.getValue().getBytes()));
            }
            catch (IOException e) {
                System.out.println("The impossible happened");
            }
            return;
        }
    }

    public void updateProperties() {
        if (this.page1 != null) {
            this.page1.updateProperties();
            this.page2.updateProperties();
            for (int i = 0; i < this.spellPaneList.size(); ++i) {
                SpellPage spellPage = (SpellPage)((Object)this.spellPaneList.get(i));
                spellPage.updateProperties();
            }
            this.notesPanel.updateProperties();
        }
    }

    public void save() {
        this.updateProperties();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.pcProperties.store(os, "Character Sheet Plugin Properties");
            NoteItem hiddenNote = null;
            Object note = null;
            int newNodeId = 0;
            ArrayList notesList = this.pc.getNotesList();
            for (int i = 0; i < notesList.size(); ++i) {
                NoteItem testNote = (NoteItem)notesList.get(i);
                if (testNote.getId() > newNodeId) {
                    newNodeId = testNote.getId();
                }
                if (!testNote.getName().equals("Hidden")) continue;
                hiddenNote = testNote;
            }
            if (hiddenNote != null) {
                hiddenNote.setValue(os.toString());
            } else {
                hiddenNote = new NoteItem(++newNodeId, -1, "Hidden", os.toString());
                this.pc.addNotesItem(hiddenNote);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setColor() {
        this.page1layout.setBackground(white);
        this.page2layout.setBackground(white);
        if (this.page1 != null) {
            this.page1.setColor();
            this.page2.setColor();
            for (int i = 0; i < this.spellPaneList.size(); ++i) {
                SpellPage spellPage = (SpellPage)((Object)this.spellPaneList.get(i));
                spellPage.setColor();
            }
        }
    }

    public static void setColorBlue() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(85, 85, 136);
        header = new Color(153, 153, 187);
        bodyDark = new Color(170, 170, 204);
        bodyMedDark = new Color(187, 187, 238);
        bodyMedLight = new Color(204, 204, 238);
        bodyLight = new Color(238, 238, 255);
    }

    public static void setColorLightBlue() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(85, 85, 136);
        header = new Color(187, 187, 238);
        bodyDark = new Color(187, 187, 238);
        bodyMedDark = new Color(204, 204, 255);
        bodyMedLight = new Color(238, 238, 255);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorGreen() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(85, 136, 85);
        header = new Color(153, 187, 153);
        bodyDark = new Color(170, 204, 170);
        bodyMedDark = new Color(187, 238, 187);
        bodyMedLight = new Color(204, 238, 204);
        bodyLight = new Color(238, 255, 238);
    }

    public static void setColorLightGreen() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(0, 136, 0);
        header = new Color(68, 204, 68);
        bodyDark = new Color(68, 204, 68);
        bodyMedDark = new Color(204, 255, 204);
        bodyMedLight = new Color(238, 255, 238);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorRed() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(163, 85, 85);
        header = new Color(187, 153, 153);
        bodyDark = new Color(204, 170, 170);
        bodyMedDark = new Color(238, 187, 187);
        bodyMedLight = new Color(238, 204, 204);
        bodyLight = new Color(255, 238, 238);
    }

    public static void setColorLightRed() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(163, 0, 0);
        header = new Color(204, 0, 0);
        bodyDark = new Color(204, 0, 0);
        bodyMedDark = new Color(255, 204, 204);
        bodyMedLight = new Color(255, 238, 238);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorYellow() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(136, 136, 85);
        header = new Color(187, 187, 153);
        bodyDark = new Color(204, 204, 170);
        bodyMedDark = new Color(221, 221, 187);
        bodyMedLight = new Color(238, 238, 204);
        bodyLight = new Color(255, 255, 221);
    }

    public static void setColorLightYellow() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(136, 136, 85);
        header = new Color(238, 238, 187);
        bodyDark = new Color(238, 238, 187);
        bodyMedDark = new Color(255, 255, 204);
        bodyMedLight = new Color(255, 255, 238);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorGrey() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(0, 0, 0);
        header = new Color(153, 153, 153);
        bodyDark = new Color(204, 204, 204);
        bodyMedDark = new Color(204, 204, 204);
        bodyMedLight = new Color(204, 204, 204);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorLightGrey() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(0, 0, 0);
        header = new Color(255, 255, 255);
        bodyDark = new Color(255, 255, 255);
        bodyMedDark = new Color(204, 204, 204);
        bodyMedLight = new Color(204, 204, 204);
        bodyLight = new Color(255, 255, 255);
    }

    private class Refresher
    extends Thread {
        private Refresher() {
        }

        public void run() {
            this.refresh();
        }

        private void refresh() {
            if (CharacterPanel.this.readyForRefresh) {
                Globals.setCurrentPC((PlayerCharacter)CharacterPanel.this.pc);
                CharacterPanel.this.updateProperties();
                if (CharacterPanel.this.mainTabs.getTabCount() > 0 && CharacterPanel.this.mainTabs.getSelectedIndex() > -1) {
                    String currentTitle = CharacterPanel.this.mainTabs.getTitleAt(CharacterPanel.this.mainTabs.getSelectedIndex());
                    JViewport viewPort = ((JScrollPane)CharacterPanel.this.mainTabs.getSelectedComponent()).getViewport();
                    ScrollablePanel sp = (ScrollablePanel)viewPort.getView();
                    Component comp = sp.getComponent(0);
                    viewPort.setViewPosition(new Point(0, 0));
                    if (currentTitle.equals("Page 1")) {
                        CharacterPanel.this.page1.refresh();
                    } else if (currentTitle.equals("Page 2")) {
                        CharacterPanel.this.page2.refresh();
                    } else if (comp instanceof SpellPage) {
                        SpellPage spellPage = (SpellPage)((Object)comp);
                        spellPage.refresh();
                    }
                }
                if (CharacterPanel.this.serial < CharacterPanel.this.pc.getSerial()) {
                    CharacterPanel.this.generateTabs(false);
                    CharacterPanel.this.notesPanel.refresh();
                    CharacterPanel.this.serial = CharacterPanel.this.pc.getSerial();
                }
            }
            CharacterPanel.this.mainTabs.repaint();
        }
    }
}

