/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import plugin.charactersheet.gui.CharacterPanel;

public class ClassSpellLevelPane
extends JPanel {
    private PlayerCharacter pc;
    private PCClass pcclass;
    private int level;
    private boolean racial = false;
    private List removeList = new ArrayList();
    private List lightList = new ArrayList();
    private List darkList = new ArrayList();
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel known;
    private JLabel perDay;
    private JLabel title;

    public ClassSpellLevelPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.known = new JLabel();
        this.jLabel3 = new JLabel();
        this.perDay = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jPanel12 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jPanel14 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 16));
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel1.setFont(new Font("Dialog", 1, 13));
        this.jLabel1.setText("  Known: ");
        this.jPanel2.add(this.jLabel1);
        this.known.setText(" ");
        this.jPanel2.add(this.known);
        this.jLabel3.setFont(new Font("Dialog", 1, 13));
        this.jLabel3.setText("     Per Day:");
        this.jPanel2.add(this.jLabel3);
        this.perDay.setFont(new Font("Dialog", 1, 13));
        this.perDay.setText(" ");
        this.jPanel2.add(this.perDay);
        this.add(this.jPanel2);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel12.setFont(new Font("Dialog", 0, 10));
        this.jLabel12.setText(" ");
        this.jPanel3.add(this.jLabel12);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel5.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel2.setFont(new Font("Dialog", 1, 11));
        this.jLabel2.setText("Name");
        this.jPanel5.add(this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel4.setFont(new Font("Dialog", 1, 11));
        this.jLabel4.setText("DC   ");
        this.jPanel6.add(this.jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel5.setFont(new Font("Dialog", 1, 11));
        this.jLabel5.setText("Saving Throw");
        this.jPanel7.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel6.setFont(new Font("Dialog", 1, 11));
        this.jLabel6.setText("Time");
        this.jPanel8.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel7.setFont(new Font("Dialog", 1, 11));
        this.jLabel7.setText("Duration");
        this.jPanel9.add(this.jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel8.setFont(new Font("Dialog", 1, 11));
        this.jLabel8.setText("Range");
        this.jPanel10.add(this.jLabel8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel11.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel9.setFont(new Font("Dialog", 1, 11));
        this.jLabel9.setText("Comp.");
        this.jPanel11.add(this.jLabel9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel12.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel10.setFont(new Font("Dialog", 1, 11));
        this.jLabel10.setText("Spell Resistance ");
        this.jPanel12.add(this.jLabel10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel12, gridBagConstraints);
        this.jPanel13.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel11.setFont(new Font("Dialog", 1, 11));
        this.jLabel11.setText("School");
        this.jPanel13.add(this.jLabel11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel13, gridBagConstraints);
        this.jPanel14.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel13.setFont(new Font("Dialog", 1, 11));
        this.jLabel13.setText("Source");
        this.jPanel14.add(this.jLabel13);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel14, gridBagConstraints);
        this.jLabel14.setFont(new Font("Dialog", 1, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 125, 0, 0);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.jPanel4.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 100, 0, 0);
        this.jPanel4.add((Component)this.jLabel16, gridBagConstraints);
        this.add(this.jPanel4);
    }

    public void setColor() {
        Component c;
        int i;
        this.setLocalColor();
        for (i = 0; i < this.lightList.size(); ++i) {
            c = (Component)this.lightList.get(i);
            c.setBackground(CharacterPanel.bodyLight);
        }
        for (i = 0; i < this.darkList.size(); ++i) {
            c = (Component)this.darkList.get(i);
            c.setBackground(CharacterPanel.bodyMedLight);
        }
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel2.setBackground(CharacterPanel.header);
        this.jPanel4.setBackground(CharacterPanel.white);
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
        this.jPanel7.setBackground(CharacterPanel.header);
        this.jPanel8.setBackground(CharacterPanel.header);
        this.jPanel9.setBackground(CharacterPanel.header);
        this.jPanel10.setBackground(CharacterPanel.header);
        this.jPanel11.setBackground(CharacterPanel.header);
        this.jPanel12.setBackground(CharacterPanel.header);
        this.jPanel13.setBackground(CharacterPanel.header);
        this.jPanel14.setBackground(CharacterPanel.header);
    }

    public void setPc(PlayerCharacter pc, PCClass pcclass, int level) {
        this.pc = pc;
        this.pcclass = pcclass;
        this.level = level;
        this.title.setText(pcclass.getDisplayClassName() + " Spells, Level " + level);
    }

    public void setPc(PlayerCharacter pc) {
        this.pc = pc;
        this.racial = true;
    }

    public void refresh() {
        String spellBook;
        List spellList;
        if (!this.racial) {
            this.known.setText(this.pcclass.getKnownForLevel(this.pcclass.getLevel(), this.level, this.pc) + "");
            this.perDay.setText(this.pcclass.getCastForLevel(this.pcclass.getLevel(), this.level, Globals.getDefaultSpellBook(), this.pc) + this.pcclass.getBonusCastForLevelString(this.pcclass.getLevel(), this.level, Globals.getDefaultSpellBook(), this.pc));
            spellList = this.pcclass.getCharacterSpell(null, Globals.getDefaultSpellBook(), this.level);
            spellBook = Globals.getDefaultSpellBook();
        } else {
            spellList = this.pc.getRace().getCharacterSpellList();
            spellBook = "Innate";
        }
        for (int i = 0; i < this.removeList.size(); ++i) {
            this.remove((Component)this.removeList.get(i));
        }
        this.removeList.clear();
        int gridY = 1;
        for (int i = 0; i < spellList.size(); ++i) {
            List colorList;
            Color color;
            if (i % 2 == 0) {
                color = CharacterPanel.bodyLight;
                colorList = this.lightList;
            } else {
                color = CharacterPanel.bodyMedLight;
                colorList = this.darkList;
            }
            CharacterSpell cs = (CharacterSpell)spellList.get(i);
            gridY = this.addLine(cs, spellBook, color, gridY, colorList);
        }
    }

    private int addLine(CharacterSpell cs, String spellBook, Color color, int gridY, List colorList) {
        Spell spell = cs.getSpell();
        SpellInfo si = cs.getSpellInfoFor(spellBook, this.level, -1);
        JPanel cbPanel = new JPanel();
        cbPanel.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)cbPanel, gridBagConstraints);
        this.removeList.add(cbPanel);
        colorList.add(cbPanel);
        JPanel namePanel = new JPanel();
        JLabel name = new JLabel();
        namePanel.setLayout(new FlowLayout(0, 1, 0));
        namePanel.setBackground(color);
        name.setFont(new Font("Dialog", 1, 11));
        name.setText(spell.getOutputName() + si);
        namePanel.add(name);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)namePanel, gridBagConstraints);
        this.removeList.add(namePanel);
        colorList.add(namePanel);
        JPanel dcPanel = new JPanel();
        JLabel dc = new JLabel();
        dcPanel.setLayout(new FlowLayout(0, 1, 0));
        dcPanel.setBackground(color);
        dc.setFont(new Font("Dialog", 1, 10));
        dc.setText(spell.getDCForPlayerCharacter(this.pc, si) + "");
        dcPanel.add(dc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)dcPanel, gridBagConstraints);
        this.removeList.add(dcPanel);
        colorList.add(dcPanel);
        JTextArea save = new JTextArea();
        save.setLineWrap(true);
        save.setWrapStyleWord(true);
        save.setBackground(color);
        save.setFont(new Font("Dialog", 0, 10));
        save.setText(spell.getSaveInfo());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)save, gridBagConstraints);
        this.removeList.add(save);
        colorList.add(save);
        JTextArea time = new JTextArea();
        time.setLineWrap(true);
        time.setWrapStyleWord(true);
        time.setBackground(color);
        time.setFont(new Font("Dialog", 0, 10));
        time.setText(spell.getCastingTime());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)time, gridBagConstraints);
        this.removeList.add(time);
        colorList.add(time);
        JTextArea duration = new JTextArea();
        duration.setLineWrap(true);
        duration.setWrapStyleWord(true);
        duration.setBackground(color);
        duration.setFont(new Font("Dialog", 0, 10));
        duration.setText(this.pc.parseSpellString(spell, spell.getDuration(), cs.getOwner()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)duration, gridBagConstraints);
        this.removeList.add(duration);
        colorList.add(duration);
        JPanel rangePanel = new JPanel();
        JLabel range = new JLabel();
        rangePanel.setLayout(new FlowLayout(0, 1, 0));
        rangePanel.setBackground(color);
        range.setFont(new Font("Dialog", 1, 10));
        range.setText(this.pc.getSpellRange(spell, cs.getOwner().getName(), si));
        rangePanel.add(range);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)rangePanel, gridBagConstraints);
        this.removeList.add(rangePanel);
        colorList.add(rangePanel);
        JPanel compPanel = new JPanel();
        JLabel comp = new JLabel();
        compPanel.setLayout(new FlowLayout(0, 1, 0));
        compPanel.setBackground(color);
        comp.setFont(new Font("Dialog", 1, 10));
        comp.setText(spell.getComponentList());
        compPanel.add(comp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)compPanel, gridBagConstraints);
        this.removeList.add(compPanel);
        colorList.add(compPanel);
        JTextArea sr = new JTextArea();
        sr.setLineWrap(true);
        sr.setWrapStyleWord(true);
        sr.setBackground(color);
        sr.setFont(new Font("Dialog", 0, 10));
        sr.setText(spell.getSpellResistance());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)sr, gridBagConstraints);
        this.removeList.add(sr);
        colorList.add(sr);
        JTextArea school = new JTextArea();
        school.setLineWrap(true);
        school.setWrapStyleWord(true);
        school.setBackground(color);
        school.setFont(new Font("Dialog", 0, 10));
        String sch = spell.getSchool();
        if (spell.getSubschool().length() > 0 && !"NONE".equals(spell.getSubschool().trim().toUpperCase())) {
            sch = sch + " (" + spell.getSubschool() + ')';
        }
        if (spell.descriptor().length() > 0) {
            sch = sch + " [" + spell.descriptor() + ']';
        }
        school.setText(sch);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)school, gridBagConstraints);
        this.removeList.add(school);
        colorList.add(school);
        JPanel sourcePanel = new JPanel();
        JLabel source = new JLabel();
        sourcePanel.setLayout(new FlowLayout(0, 1, 0));
        sourcePanel.setBackground(color);
        source.setFont(new Font("Dialog", 1, 10));
        source.setText(spell.getSourceShort(8) + ": " + spell.getSourcePage());
        sourcePanel.add(source);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = gridY++;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)sourcePanel, gridBagConstraints);
        this.removeList.add(sourcePanel);
        colorList.add(sourcePanel);
        JPanel cb1Panel = new JPanel();
        cb1Panel.setBackground(color);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)cb1Panel, gridBagConstraints);
        this.removeList.add(cb1Panel);
        colorList.add(cb1Panel);
        JTextArea effect = new JTextArea();
        effect.setLineWrap(true);
        effect.setWrapStyleWord(true);
        effect.setBackground(color);
        effect.setFont(new Font("Dialog", 0, 10));
        effect.setText("Effect: " + this.pc.parseSpellString(spell, spell.getDescription(), cs.getOwner()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)effect, gridBagConstraints);
        this.removeList.add(effect);
        colorList.add(effect);
        JTextArea target = new JTextArea();
        target.setLineWrap(true);
        target.setWrapStyleWord(true);
        target.setBackground(color);
        target.setFont(new Font("Dialog", 0, 10));
        target.setText("Target: " + this.pc.parseSpellString(spell, spell.getTarget(), cs.getOwner()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = gridY++;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)target, gridBagConstraints);
        this.removeList.add(target);
        colorList.add(target);
        return gridY;
    }
}

