/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.GridBoxLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import plugin.charactersheet.gui.CharacterPanel;

public class DualListPane
extends JPanel {
    private Map map = new HashMap();
    private JPanel jPanel1;
    private JPanel listPane;
    private JLabel title;

    public DualListPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.listPane = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 14));
        this.title.setText(" ");
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.listPane.setLayout((LayoutManager)new GridBoxLayout(0, 1));
        this.add(this.listPane);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.listPane.setBackground(CharacterPanel.white);
        this.listPane.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setMap(String title, Map map) {
        this.map = map;
        this.title.setText(title);
        this.setVisible(false);
        this.refresh();
    }

    public void refresh() {
        if (this.map.size() > 0) {
            this.setVisible(true);
            this.listPane.removeAll();
            Set keySet = this.map.keySet();
            int i = 0;
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Color color = i % 2 == 0 ? CharacterPanel.bodyLight : CharacterPanel.bodyMedLight;
                this.addLine(key, (String)this.map.get(key), color);
                ++i;
            }
        } else {
            this.setVisible(false);
        }
    }

    private void addLine(String text1, String text2, Color color) {
        JTextArea listDisplay1 = new JTextArea();
        listDisplay1.setLineWrap(true);
        listDisplay1.setWrapStyleWord(true);
        listDisplay1.setBackground(color);
        listDisplay1.setFont(new Font("Dialog", 1, 11));
        listDisplay1.setText(text1);
        this.listPane.add(listDisplay1);
        if (!text2.equals("")) {
            JTextArea listDisplay2 = new JTextArea();
            listDisplay2.setLineWrap(true);
            listDisplay2.setWrapStyleWord(true);
            listDisplay2.setBackground(color);
            listDisplay2.setFont(new Font("Dialog", 0, 10));
            listDisplay2.setText(text2);
            this.listPane.add(listDisplay2);
        }
    }
}

