/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.EqToken;
import pcgen.io.exporttoken.TotalToken;
import pcgen.util.BigDecimalHelper;
import plugin.charactersheet.gui.CharacterPanel;

public class EquipmentPane
extends JPanel {
    private PlayerCharacter pc;
    private List removeList = new ArrayList();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7 = new JPanel();
    private JPanel jPanel8 = new JPanel();
    private JPanel jPanel9 = new JPanel();
    private JPanel jPanel10 = new JPanel();
    private JPanel jPanel11 = new JPanel();
    private JLabel jLabel8 = new JLabel();
    private JLabel jLabel9 = new JLabel();
    private JLabel jLabel10 = new JLabel();
    private JLabel totalWeight = new JLabel();
    private JLabel totalGp = new JLabel();

    public EquipmentPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setText("Equipment");
        this.jPanel1.add(this.jLabel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel1.setFont(new Font("Dialog", 0, 10));
        this.jLabel1.setText("ITEM");
        this.jPanel2.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel3.setFont(new Font("Dialog", 0, 10));
        this.jLabel3.setText("LOCATION");
        this.jPanel3.add(this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel4.setFont(new Font("Dialog", 0, 10));
        this.jLabel4.setText("QTY");
        this.jPanel4.add(this.jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel6.setFont(new Font("Dialog", 0, 10));
        this.jLabel6.setText("COST");
        this.jPanel5.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel5.setFont(new Font("Dialog", 0, 10));
        this.jLabel5.setText("WT");
        this.jPanel6.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 200, 0, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel2.setBackground(CharacterPanel.header);
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel4.setBackground(CharacterPanel.header);
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
    }

    public void setPc(PlayerCharacter pc) {
        this.pc = pc;
    }

    public void refresh() {
        List eqList = this.getEqList(this.pc);
        if (eqList.size() == 0) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            for (int i = 0; i < this.removeList.size(); ++i) {
                this.remove((Component)this.removeList.get(i));
            }
            this.removeList.clear();
            int gridY = 2;
            for (int i = 0; i < eqList.size(); ++i) {
                Color color = i % 2 == 0 ? CharacterPanel.bodyLight : CharacterPanel.bodyMedLight;
                Equipment eq = (Equipment)eqList.get(i);
                gridY = this.addLine(eq, color, gridY);
            }
            this.addEnd(gridY, TotalToken.getWeightToken((PlayerCharacter)this.pc), TotalToken.getValueToken((PlayerCharacter)this.pc));
        }
    }

    private int addLine(Equipment eq, Color color, int gridY) {
        int boxes;
        String noteText;
        String spropText;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea item = new JTextArea();
        item.setLineWrap(true);
        item.setWrapStyleWord(true);
        item.setBackground(color);
        int bold = 0;
        if (eq.isEquipped()) {
            bold = 1;
        }
        item.setFont(new Font("Dialog", bold, 11));
        item.setText(EqToken.getLongNameToken((Equipment)eq));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)item, gridBagConstraints);
        this.removeList.add(item);
        JPanel locationPanel = new JPanel();
        JLabel location = new JLabel();
        locationPanel.setLayout(new FlowLayout(1, 1, 0));
        locationPanel.setBackground(color);
        location.setFont(new Font("Dialog", 0, 10));
        location.setText(EqToken.getLocationToken((Equipment)eq));
        locationPanel.add(location);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)locationPanel, gridBagConstraints);
        this.removeList.add(locationPanel);
        JPanel qtyPanel = new JPanel();
        JLabel qty = new JLabel();
        qtyPanel.setLayout(new FlowLayout(1, 1, 0));
        qtyPanel.setBackground(color);
        qty.setFont(new Font("Dialog", 0, 10));
        qty.setText(EqToken.getQtyToken((Equipment)eq));
        qtyPanel.add(qty);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)qtyPanel, gridBagConstraints);
        this.removeList.add(qtyPanel);
        JPanel wtPanel = new JPanel();
        JLabel wt = new JLabel();
        wtPanel.setLayout(new FlowLayout(1, 1, 0));
        wtPanel.setBackground(color);
        wt.setFont(new Font("Dialog", 0, 10));
        wt.setText(EqToken.getWtToken((PlayerCharacter)this.pc, (Equipment)eq));
        wtPanel.add(wt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)wtPanel, gridBagConstraints);
        this.removeList.add(wtPanel);
        JPanel costPanel = new JPanel();
        JLabel cost = new JLabel();
        costPanel.setLayout(new FlowLayout(1, 1, 0));
        costPanel.setBackground(color);
        cost.setFont(new Font("Dialog", 0, 10));
        cost.setText(EqToken.getCostToken((PlayerCharacter)this.pc, (Equipment)eq));
        costPanel.add(cost);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = gridY++;
        gridBagConstraints.fill = 1;
        this.add((Component)costPanel, gridBagConstraints);
        this.removeList.add(costPanel);
        JPanel panel1 = new JPanel();
        panel1.setBackground(color);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)panel1, gridBagConstraints);
        this.removeList.add(panel1);
        JPanel panel2 = new JPanel();
        panel2.setBackground(color);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)panel2, gridBagConstraints);
        this.removeList.add(panel2);
        JPanel totalWtPanel = new JPanel();
        totalWtPanel.setLayout(new FlowLayout(1, 1, 0));
        totalWtPanel.setBackground(color);
        if (eq.qty() > 1.0) {
            JLabel totalWt = new JLabel();
            totalWt.setFont(new Font("Dialog", 0, 10));
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(0);
            totalWt.setText("(" + format.format(eq.qty() * eq.getWeightAsDouble(this.pc)) + ")");
            totalWtPanel.add(totalWt);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)totalWtPanel, gridBagConstraints);
        this.removeList.add(totalWtPanel);
        JPanel totalCostPanel = new JPanel();
        totalCostPanel.setLayout(new FlowLayout(1, 1, 0));
        totalCostPanel.setBackground(color);
        if (eq.qty() > 1.0) {
            JLabel totalCost = new JLabel();
            totalCost.setFont(new Font("Dialog", 0, 10));
            BigDecimal bdTotalCost = eq.getCost(this.pc).multiply(new BigDecimal(eq.qty()));
            totalCost.setText("(" + BigDecimalHelper.trimZeros((BigDecimal)bdTotalCost) + ")");
            totalCostPanel.add(totalCost);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = gridY++;
        gridBagConstraints.fill = 1;
        this.add((Component)totalCostPanel, gridBagConstraints);
        this.removeList.add(totalCostPanel);
        String contentsText = EqToken.getContentsToken((Equipment)eq);
        if (!contentsText.equals("")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridY++;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            JTextArea contents = new JTextArea();
            contents.setLineWrap(true);
            contents.setWrapStyleWord(true);
            contents.setBackground(color);
            contents.setFont(new Font("Dialog", 0, 9));
            contents.setText(contentsText);
            this.add((Component)contents, gridBagConstraints);
            this.removeList.add(contents);
        }
        if (!(spropText = EqToken.getSpropToken((PlayerCharacter)this.pc, (Equipment)eq)).equals("")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridY++;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            JTextArea sprop = new JTextArea();
            sprop.setLineWrap(true);
            sprop.setWrapStyleWord(true);
            sprop.setBackground(color);
            sprop.setFont(new Font("Dialog", 0, 9));
            sprop.setText(spropText);
            this.add((Component)sprop, gridBagConstraints);
            this.removeList.add(sprop);
        }
        if (!(noteText = EqToken.getNoteToken((Equipment)eq)).equals("")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridY++;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            JTextArea note = new JTextArea();
            note.setLineWrap(true);
            note.setWrapStyleWord(true);
            note.setBackground(color);
            note.setFont(new Font("Dialog", 0, 9));
            note.setText(noteText);
            this.add((Component)note, gridBagConstraints);
            this.removeList.add(note);
        }
        if ((boxes = this.getBoxes(eq)) > 0) {
            JPanel panel = new JPanel();
            for (int i = 0; i < boxes; ++i) {
                if (i % 25 == 0) {
                    panel = new JPanel();
                    panel.setLayout(new FlowLayout(0, 0, 1));
                    panel.setBackground(color);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = gridY++;
                    gridBagConstraints.gridwidth = 5;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.fill = 1;
                    this.add((Component)panel, gridBagConstraints);
                    this.removeList.add(panel);
                }
                if (i % 5 == 0) {
                    JLabel bufLabel = new JLabel();
                    bufLabel.setFont(new Font("Dialog", 0, 10));
                    bufLabel.setText(" ");
                    panel.add(bufLabel);
                }
                JCheckBox checkBox = new JCheckBox();
                checkBox.setBackground(color);
                checkBox.setBorder(null);
                panel.add(checkBox);
            }
        }
        return gridY;
    }

    private void addEnd(int gridY, String weight, String gp) {
        this.jPanel7.setLayout(new FlowLayout(1, 1, 0));
        this.jPanel7.setBackground(CharacterPanel.header);
        this.jLabel9.setFont(new Font("Dialog", 0, 10));
        this.jLabel9.setText("TOTAL WEIGHT CARRIED/VALUE");
        this.jPanel7.add(this.jLabel9);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.removeList.add(this.jPanel7);
        this.jPanel8.setLayout(new FlowLayout(1, 1, 0));
        this.jPanel8.setBackground(CharacterPanel.header);
        this.totalWeight.setFont(new Font("Dialog", 0, 10));
        this.totalWeight.setText(weight);
        this.jPanel8.add(this.totalWeight);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel8, gridBagConstraints);
        this.removeList.add(this.jPanel8);
        this.jPanel9.setLayout(new FlowLayout(1, 1, 0));
        this.jPanel9.setBackground(CharacterPanel.header);
        this.totalGp.setFont(new Font("Dialog", 0, 10));
        this.totalGp.setText(gp);
        this.jPanel9.add(this.totalGp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel9, gridBagConstraints);
        this.removeList.add(this.jPanel9);
    }

    private List getEqList(PlayerCharacter pc) {
        int merge = 2;
        List eqList = pc.getEquipmentListInOutputOrder(merge);
        eqList = PlayerCharacter.removeEqType((List)eqList, (String)"Coin");
        eqList = PlayerCharacter.removeEqType((List)eqList, (String)"Gem");
        return eqList;
    }

    private int getBoxes(Equipment eq) {
        int num = 0;
        if (eq.isType("Ammunition") || eq.isType("Potion")) {
            num = (int)EqToken.getQtyDoubleToken((Equipment)eq);
        } else if (eq.getRemainingCharges() > 0) {
            num = EqToken.getChargesTokenInt((Equipment)eq);
        }
        return num;
    }
}

