/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class NotesPanel
extends JSplitPane {
    private PlayerCharacter pc;
    private Properties pcProperties;
    private boolean textIsDirty = false;
    private NoteItem bioNote = null;
    private NoteItem companionNote = null;
    private NoteItem currentItem = null;
    private NoteItem descriptionNote = null;
    private NoteItem lastItem = null;
    private NoteItem magicItemsNote = null;
    private NoteItem otherAssetsNote = null;
    private NoteItem portraitNote = null;
    private NoteTreeNode rootTreeNode;
    private DefaultTreeModel notesModel;
    private int serial = 0;
    private static final int BIO_NOTEID = -2;
    private static final int DESCRIPTION_NOTEID = -3;
    private static final int COMPANION_NOTEID = -4;
    private static final int OTHERASSETS_NOTEID = -5;
    private static final int MAGICITEMS_NOTEID = -6;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JButton moveButton;
    private JTextArea notesArea;
    private JTree notesTree;
    private JButton renameButton;

    public NotesPanel() {
        this.initComponents();
        this.addListeners();
        this.initPrefs();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.notesArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.notesTree = new JTree();
        this.jToolBar1 = new JToolBar();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.moveButton = new JButton();
        this.setDividerSize(1);
        this.setOrientation(0);
        this.setPreferredSize(new Dimension(360, 78));
        this.notesArea.setLineWrap(true);
        this.notesArea.setWrapStyleWord(true);
        this.notesArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                NotesPanel.this.notesAreaFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.notesArea);
        this.setBottomComponent(this.jScrollPane1);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView(this.notesTree);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.addButton.setText(PropertyFactory.getString((String)"in_add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addButton);
        this.deleteButton.setText(PropertyFactory.getString((String)"in_delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.deleteButton);
        this.renameButton.setText(PropertyFactory.getString((String)"in_rename"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.renameButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.renameButton);
        this.moveButton.setText(PropertyFactory.getString((String)"in_move"));
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.moveButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.moveButton);
        this.jPanel1.add((Component)this.jToolBar1, "South");
        this.setTopComponent(this.jPanel1);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addNode();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteNode();
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        this.renameNode();
    }

    private void moveButtonActionPerformed(ActionEvent evt) {
        this.moveNode();
    }

    private void notesAreaFocusLost(FocusEvent evt) {
        this.updateNoteItem();
    }

    private void initPrefs() {
        int iDividerLocation = SettingsHandler.getGMGenOption((String)"CharacterSheet.notes.DividerLocation", (int)100);
        this.setDividerLocation(iDividerLocation);
    }

    public void flushPrefs() {
        SettingsHandler.setGMGenOption((String)"CharacterSheet.notes.DividerLocation", (int)this.getDividerLocation());
    }

    private void addNode() {
        TreePath selPath = this.notesTree.getSelectionPath();
        if (selPath == null) {
            return;
        }
        NoteTreeNode parentTreeNode = (NoteTreeNode)selPath.getLastPathComponent();
        parentTreeNode.addNote();
        this.notesTree.updateUI();
        this.notesTree.expandPath(selPath);
    }

    private void deleteNode() {
        TreePath selPath = this.notesTree.getSelectionPath();
        if (selPath == null) {
            return;
        }
        Object o = selPath.getLastPathComponent();
        if (o == null || ((NoteTreeNode)o).getItem() == null) {
            return;
        }
        NoteTreeNode node = (NoteTreeNode)o;
        node.deleteNote();
        this.notesTree.updateUI();
    }

    private void renameNode() {
        TreePath selPath = this.notesTree.getSelectionPath();
        if (selPath == null) {
            return;
        }
        this.notesTree.startEditingAtPath(selPath);
    }

    private void moveNode() {
        this.lastItem = this.currentItem;
    }

    private void addListeners() {
        this.notesArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                NotesPanel.this.docChange(e);
            }

            public void insertUpdate(DocumentEvent e) {
                NotesPanel.this.docChange(e);
            }

            public void removeUpdate(DocumentEvent e) {
                NotesPanel.this.docChange(e);
            }
        });
        this.notesTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = NotesPanel.this.notesTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = NotesPanel.this.notesTree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && selPath != null) {
                    NotesPanel.this.selectNotesNode(selRow);
                }
                NotesPanel.this.lastItem = null;
            }
        });
        TreeModel model = this.notesTree.getModel();
        this.notesTree.setEditable(true);
        this.notesTree.addMouseListener(new NotePopupListener(this.notesTree, new NotePopupMenu()));
    }

    public void docChange(DocumentEvent e) {
        this.textIsDirty = true;
    }

    public void setPc(PlayerCharacter pc, Properties pcProperties) {
        this.pc = pc;
        this.pcProperties = pcProperties;
        this.populateNotes();
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            if (this.currentItem != null) {
                this.updateNoteItem();
            }
            this.establishTreeNodes();
            this.notesTree.expandRow(0);
            this.selectNotesNode(this.getCSNode());
            this.serial = this.pc.getSerial();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    private void populateNotes() {
        ArrayList notesList = this.pc.getNotesList();
        NoteItem csNotes = null;
        int newNodeId = 0;
        for (int i = 0; i < notesList.size(); ++i) {
            NoteItem note = (NoteItem)notesList.get(i);
            if (note.getId() > newNodeId) {
                newNodeId = note.getId();
            }
            if (!note.getName().equals("Character Sheet Notes")) continue;
            csNotes = note;
        }
        if (csNotes == null) {
            csNotes = new NoteItem(++newNodeId, -1, "Character Sheet Notes", "");
            this.pc.addNotesItem(csNotes);
        }
        this.establishTreeNodes();
    }

    private NoteTreeNode getCSNode() {
        Enumeration<TreeNode> e = this.rootTreeNode.children();
        while (e.hasMoreElements()) {
            NoteTreeNode node = (NoteTreeNode)e.nextElement();
            if (!node.toString().equals("Character Sheet Notes")) continue;
            return node;
        }
        return this.rootTreeNode;
    }

    public void updateProperties() {
    }

    private void establishTreeNodes() {
        int index = -1;
        ArrayList<NoteItem> nodesToBeAddedList = new ArrayList<NoteItem>();
        int order = 0;
        this.rootTreeNode = new NoteTreeNode(null, this.pc);
        this.notesModel = new DefaultTreeModel(this.rootTreeNode);
        this.notesTree.setModel(this.notesModel);
        ArrayList testList = this.pc.getNotesList();
        for (int i = 0; i < testList.size(); ++i) {
            NoteItem testnote = (NoteItem)testList.get(i);
            nodesToBeAddedList.add(testnote);
        }
        this.bioNote = new NoteItem(-2, -1, "Bio", this.pc.getBio());
        nodesToBeAddedList.add(order++, this.bioNote);
        this.descriptionNote = new NoteItem(-3, -1, PropertyFactory.getString((String)"in_descrip"), this.pc.getDescription());
        nodesToBeAddedList.add(order++, this.descriptionNote);
        this.companionNote = new NoteItem(-4, -1, PropertyFactory.getString((String)"in_companions"), (String)this.pc.getMiscList().get(1));
        nodesToBeAddedList.add(order++, this.companionNote);
        this.otherAssetsNote = new NoteItem(-5, -1, PropertyFactory.getString((String)"in_otherAssets"), (String)this.pc.getMiscList().get(0));
        nodesToBeAddedList.add(order++, this.otherAssetsNote);
        this.magicItemsNote = new NoteItem(-6, -1, PropertyFactory.getString((String)"in_magicItems"), (String)this.pc.getMiscList().get(2));
        nodesToBeAddedList.add(order++, this.magicItemsNote);
        this.addNodes(this.rootTreeNode, nodesToBeAddedList);
    }

    private void addNodes(NoteTreeNode node, List nodesToBeAddedList) {
        int i;
        int index = -1;
        if (node.getItem() != null) {
            index = node.getItem().getId();
        }
        for (i = 0; i < nodesToBeAddedList.size(); ++i) {
            NoteItem ni = (NoteItem)nodesToBeAddedList.get(i);
            if (ni.getParentId() != index) continue;
            NoteTreeNode childNode = new NoteTreeNode(ni, this.pc);
            node.add(childNode);
            nodesToBeAddedList.remove(i);
            --i;
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            this.addNodes((NoteTreeNode)node.getChildAt(i), nodesToBeAddedList);
        }
    }

    private void selectNotesNode(int rowNum) {
        this.notesTree.requestFocus();
        this.notesTree.setSelectionRow(rowNum);
        TreePath path = this.notesTree.getSelectionPath();
        Object o = path.getLastPathComponent();
        if (o != null && o instanceof NoteTreeNode) {
            this.selectNotesNode((NoteTreeNode)o);
        }
    }

    private void selectNotesNode(NoteTreeNode node) {
        NoteItem selectedItem;
        if (this.currentItem != null) {
            this.updateNoteItem();
        }
        this.notesTree.expandPath(new TreePath(this.notesModel.getPathToRoot(node)));
        this.currentItem = selectedItem = node.getItem();
        if (selectedItem != null) {
            this.notesArea.setText(this.currentItem.getValue());
            if (this.lastItem != null) {
                int oldParent = this.currentItem.getParentId();
                this.currentItem.setParentId(this.lastItem.getParentId());
                this.lastItem.setParentId(oldParent);
                this.establishTreeNodes();
                this.notesModel.setRoot(this.rootTreeNode);
                this.notesTree.updateUI();
            }
            this.notesArea.setEnabled(true);
            this.notesArea.setEditable(true);
        } else {
            this.notesArea.setText(PropertyFactory.getString((String)"in_idNoteEdit"));
            this.notesArea.setEnabled(false);
            this.notesArea.setEditable(false);
        }
        this.notesArea.setCaretPosition(0);
    }

    private void updateNoteItem() {
        if (this.currentItem != null && this.textIsDirty) {
            int x = this.pc.getNotesList().indexOf(this.currentItem);
            this.currentItem.setValue(this.notesArea.getText());
            if (x > -1) {
                ((NoteItem)this.pc.getNotesList().get(x)).setValue(this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.bioNote) {
                this.pc.setBio(this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.descriptionNote) {
                this.pc.setDescription(this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.otherAssetsNote) {
                this.pc.getMiscList().set(0, this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.companionNote) {
                this.pc.getMiscList().set(1, this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.magicItemsNote) {
                this.pc.getMiscList().set(2, this.notesArea.getText());
                this.pc.setDirty(true);
            }
            this.textIsDirty = false;
        }
    }

    private class NotePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -8015559748421397718L;

        NotePopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString((String)"in_add"), "shortcut EQUALS"));
            this.add(this.createRemoveMenuItem(PropertyFactory.getString((String)"in_remove"), "shortcut MINUS"));
            this.add(this.createRenameMenuItem(PropertyFactory.getString((String)"in_rename"), "alt M"));
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem((String)label, (ActionListener)new AddNoteActionListener(), (String)PropertyFactory.getString((String)"in_add"), (char)'\u0000', (String)accelerator, (String)PropertyFactory.getString((String)"in_add"), (String)"Add16.gif", (boolean)true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem((String)label, (ActionListener)new RemoveNoteActionListener(), (String)PropertyFactory.getString((String)"in_delete"), (char)'\u0000', (String)accelerator, (String)PropertyFactory.getString((String)"in_delete"), (String)"Remove16.gif", (boolean)true);
        }

        private JMenuItem createRenameMenuItem(String label, String accelerator) {
            return Utility.createMenuItem((String)label, (ActionListener)new RenameNoteActionListener(), (String)PropertyFactory.getString((String)"in_rename"), (char)'\u0000', (String)accelerator, (String)PropertyFactory.getString((String)"in_rename"), (String)"Add16.gif", (boolean)true);
        }

        private class RenameNoteActionListener
        extends NoteActionListener {
            RenameNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.renameButton.doClick();
            }
        }

        private class RemoveNoteActionListener
        extends NoteActionListener {
            RemoveNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.deleteButton.doClick();
            }
        }

        private class NoteActionListener
        implements ActionListener {
            private NoteTreeNode aNode = null;

            NoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class AddNoteActionListener
        extends NoteActionListener {
            AddNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                NotesPanel.this.addButton.doClick();
            }
        }
    }

    private class NotePopupListener
    extends MouseAdapter {
        private JTree notesTree;
        private NotePopupMenu notesMenu;

        NotePopupListener(JTree notesTree, NotePopupMenu menu) {
            this.notesTree = notesTree;
            this.notesMenu = menu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ NotePopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    NotePopupListener.access$900(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < NotePopupListener.access$1000(this.this$1).getComponentCount(); ++i) {
                            JMenuItem menuItem = (JMenuItem)NotePopupListener.access$1000(this.this$1).getComponent(i);
                            KeyStroke ks = menuItem.getAccelerator();
                            if (ks == null || !keyStroke.equals(ks)) continue;
                            menuItem.doClick(2);
                            return;
                        }
                    }
                    NotePopupListener.access$900(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    NotePopupListener.access$900(this.this$1).dispatchEvent(e);
                }
            };
            notesTree.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                TreePath selPath = this.notesTree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (selPath == null) {
                    return;
                }
                this.notesTree.setSelectionPath(selPath);
                this.notesMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ NotesPanel access$900(NotePopupListener x0) {
            return x0.NotesPanel.this;
        }

        static /* synthetic */ NotePopupMenu access$1000(NotePopupListener x0) {
            return x0.notesMenu;
        }
    }

    private static class NoteTreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -8015559748421397718L;
        private NoteItem item;
        private PlayerCharacter pc;

        NoteTreeNode(NoteItem item, PlayerCharacter pc) {
            this.item = item;
            this.pc = pc;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return this.pc.getDisplayName();
        }

        public void setUserObject(Object userObject) {
            super.setUserObject(userObject);
            this.renameNote((String)userObject);
        }

        private final NoteItem getItem() {
            return this.item;
        }

        public void renameNote(String name) {
            this.getItem().setName(name);
            this.pc.setDirty(true);
        }

        public void deleteNote() {
            NoteTreeNode parent;
            int numChildren = 0;
            Enumeration<TreeNode> allChildren = this.breadthFirstEnumeration();
            while (allChildren.hasMoreElements()) {
                NoteTreeNode ancestorNode = (NoteTreeNode)allChildren.nextElement();
                if (ancestorNode == this) continue;
                ++numChildren;
            }
            int reallyDelete = JOptionPane.showConfirmDialog(null, PropertyFactory.getString((String)"in_delNote1") + " " + this.toString() + (numChildren > 0 ? " " + PropertyFactory.getString((String)"in_delNote2") + " " + numChildren + " " + PropertyFactory.getString((String)"in_delNote3") : " ") + "?", PropertyFactory.getString((String)"in_delNote4"), 2);
            if (reallyDelete == 0 && (parent = (NoteTreeNode)this.getParent()) != null) {
                allChildren = this.breadthFirstEnumeration();
                while (allChildren.hasMoreElements()) {
                    NoteTreeNode ancestorNode = (NoteTreeNode)allChildren.nextElement();
                    this.pc.getNotesList().remove(ancestorNode.getItem());
                }
                parent.remove(this);
                this.pc.setDirty(true);
            }
        }

        public void addNote() {
            int parentId = -1;
            int newNodeId = 0;
            parentId = this.getItem().getId();
            Iterator allNotes = this.pc.getNotesList().iterator();
            while (allNotes.hasNext()) {
                NoteItem currItem = (NoteItem)allNotes.next();
                if (currItem.getId() <= newNodeId) continue;
                newNodeId = currItem.getId();
            }
            NoteItem note = new NoteItem(++newNodeId, parentId, PropertyFactory.getString((String)"in_newItem"), PropertyFactory.getString((String)"in_newValue"));
            NoteTreeNode node = new NoteTreeNode(note, this.pc);
            this.add(node);
            this.pc.addNotesItem(note);
            this.pc.setDirty(true);
        }
    }
}

