/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.DomainToken;
import pcgen.io.exporttoken.EqToken;
import plugin.charactersheet.CharacterSheetUtils;
import plugin.charactersheet.gui.CharacterPanel;
import plugin.charactersheet.gui.DualListPane;
import plugin.charactersheet.gui.EquipmentPane;
import plugin.charactersheet.gui.ListPane;
import plugin.charactersheet.gui.ShortListPane;
import plugin.charactersheet.gui.WeightPane;

public class Page2Panel
extends JPanel {
    private PlayerCharacter pc;
    private Properties pcProperties;
    private JPanel col1 = new JPanel();
    private JPanel col2 = new JPanel();
    private EquipmentPane equipmentPane = new EquipmentPane();
    private ShortListPane specialPane = new ShortListPane();
    private ListPane weaponProfPane = new ListPane();
    private ShortListPane languagePane = new ShortListPane();
    private ShortListPane templatePane = new ShortListPane();
    private ShortListPane moneyPane = new ShortListPane();
    private ShortListPane magicPane = new ShortListPane();
    private WeightPane weightPane = new WeightPane();
    private DualListPane domainPane = new DualListPane();
    private DualListPane featPane = new DualListPane();
    private JPanel gluePane1 = new JPanel();
    private JPanel gluePane2 = new JPanel();
    private int serial = 0;

    public Page2Panel() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(0));
        this.col1.setLayout(new GridBagLayout());
        this.add(this.col1);
        this.col2.setLayout(new GridBagLayout());
        this.add(this.col2);
        CharacterSheetUtils.addGbComponentCell(this.col1, this.equipmentPane, 0, 0, 1, 1, new Insets(0, 0, 0, 0), 1, 10);
        this.gluePane1.setBackground(CharacterPanel.white);
        this.gluePane1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.gluePane1.setPreferredSize(new Dimension(20, 20));
        CharacterSheetUtils.addGbComponentCell(this.col1, this.gluePane1, 0, 1, 9, 1, new Insets(5, 0, 0, 0), 0, 17);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.weightPane, 0, 0, 1, 1, new Insets(0, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.moneyPane, 0, 1, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.magicPane, 0, 2, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.specialPane, 0, 3, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.featPane, 0, 4, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.domainPane, 0, 5, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.weaponProfPane, 0, 6, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.languagePane, 0, 7, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        CharacterSheetUtils.addGbComponentCell(this.col2, this.templatePane, 0, 8, 1, 1, new Insets(5, 0, 0, 0), 1, 10);
        this.gluePane2.setBackground(CharacterPanel.white);
        this.gluePane2.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.gluePane2.setPreferredSize(new Dimension(20, 20));
        CharacterSheetUtils.addGbComponentCell(this.col2, this.gluePane2, 0, 9, 1, 1, new Insets(5, 0, 0, 0), 0, 17);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
                Page2Panel.this.updateBuffer();
            }

            public void componentMoved(ComponentEvent e) {
                Page2Panel.this.updateBuffer();
            }

            public void componentResized(ComponentEvent e) {
                Page2Panel.this.updateBuffer();
            }

            public void componentShown(ComponentEvent e) {
                Page2Panel.this.updateBuffer();
            }
        });
    }

    public void setColor() {
        this.setLocalColor();
        this.domainPane.setColor();
        this.featPane.setColor();
        this.equipmentPane.setColor();
        this.weaponProfPane.setColor();
        this.specialPane.setColor();
        this.languagePane.setColor();
        this.templatePane.setColor();
        this.moneyPane.setColor();
        this.magicPane.setColor();
        this.weightPane.setColor();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.col1.setBackground(CharacterPanel.white);
        this.col2.setBackground(CharacterPanel.white);
        this.gluePane1.setBackground(CharacterPanel.white);
        this.gluePane2.setBackground(CharacterPanel.white);
    }

    public void setPc(PlayerCharacter pc, Properties pcProperties) {
        this.pc = pc;
        this.pcProperties = pcProperties;
        this.equipmentPane.setPc(pc);
        this.weightPane.setPc(pc);
        this.updateBuffer();
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            this.equipmentPane.refresh();
            this.weightPane.refresh();
            this.moneyPane.setList("MONEY", this.getMoneyList(this.pc));
            this.magicPane.setList("MAGIC", this.getMagicList(this.pc));
            this.specialPane.setList("SPECIAL ABILITIES", this.pc.getSpecialAbilityTimesList());
            this.weaponProfPane.setList("WEAPON PROFICIENCIES", new ArrayList(this.pc.getWeaponProfList()));
            this.languagePane.setList("LANGUAGES", new ArrayList(this.pc.getLanguagesList()));
            this.templatePane.setList("TEMPLATES", this.pc.getTemplateList());
            this.domainPane.setMap("DOMAINS", this.getDomainMap(this.pc));
            this.featPane.setMap("FEATS", this.getFeatMap(this.pc));
            this.serial = this.pc.getSerial();
        }
        this.updateBuffer();
    }

    public void updateProperties() {
    }

    private void updateBuffer() {
        int left = this.equipmentPane.getHeight();
        int right = this.weightPane.getHeight() + this.moneyPane.getHeight() + this.magicPane.getHeight() + this.specialPane.getHeight() + this.featPane.getHeight() + this.domainPane.getHeight() + this.weaponProfPane.getHeight() + this.languagePane.getHeight() + this.templatePane.getHeight() - 5;
        if (this.domainPane.isVisible()) {
            right += 5;
        }
        if (this.featPane.isVisible()) {
            right += 5;
        }
        if (this.equipmentPane.isVisible()) {
            right += 5;
        }
        if (this.weaponProfPane.isVisible()) {
            right += 5;
        }
        if (this.specialPane.isVisible()) {
            right += 5;
        }
        if (this.languagePane.isVisible()) {
            right += 5;
        }
        if (this.templatePane.isVisible()) {
            right += 5;
        }
        if (this.moneyPane.isVisible()) {
            right += 5;
        }
        if (this.magicPane.isVisible()) {
            right += 5;
        }
        if (left > right) {
            int height = left - right;
            this.gluePane2.setPreferredSize(new Dimension(20, height));
            this.gluePane2.setMinimumSize(new Dimension(20, height));
            this.col1.remove(this.gluePane1);
            CharacterSheetUtils.addGbComponentCell(this.col2, this.gluePane2, 0, 9, 1, 1, new Insets(0, 0, 0, 0), 1, 10);
        } else if (right > left) {
            int height = right - left;
            this.gluePane1.setPreferredSize(new Dimension(20, height));
            this.col2.remove(this.gluePane2);
            CharacterSheetUtils.addGbComponentCell(this.col1, this.gluePane1, 0, 1, 9, 1, new Insets(0, 0, 0, 0), 1, 10);
        }
    }

    private Map getDomainMap(PlayerCharacter pc) {
        int numDomains = pc.getCharacterDomainList().size();
        HashMap<String, String> domainMap = new HashMap<String, String>();
        for (int i = 0; i < numDomains; ++i) {
            domainMap.put(DomainToken.getDomainToken((PlayerCharacter)pc, (int)i), DomainToken.getPowerToken((PlayerCharacter)pc, (int)i));
        }
        return domainMap;
    }

    private Map getFeatMap(PlayerCharacter pc) {
        List feats = pc.aggregateVisibleFeatList();
        HashMap<String, String> featMap = new HashMap<String, String>();
        for (int i = 0; i < feats.size(); ++i) {
            Feat feat = (Feat)feats.get(i);
            featMap.put(feat.qualifiedName(), feat.getBenefitDescription());
        }
        return featMap;
    }

    private List getMoneyList(PlayerCharacter pc) {
        Equipment eq;
        int i;
        int merge = 2;
        ArrayList<String> returnList = new ArrayList<String>();
        List moneyList = pc.getEquipmentOfTypeInOutputOrder("Coin", 3, merge);
        for (i = 0; i < moneyList.size(); ++i) {
            eq = (Equipment)moneyList.get(i);
            returnList.add(EqToken.getLongNameToken((Equipment)eq) + ": " + EqToken.getQtyToken((Equipment)eq));
        }
        moneyList = pc.getEquipmentOfTypeInOutputOrder("Gem", 3, merge);
        for (i = 0; i < moneyList.size(); ++i) {
            eq = (Equipment)moneyList.get(i);
            returnList.add(EqToken.getQtyToken((Equipment)eq) + " x " + EqToken.getLongNameToken((Equipment)eq) + " (" + EqToken.getCostToken((PlayerCharacter)pc, (Equipment)eq) + ")");
        }
        return returnList;
    }

    private List getMagicList(PlayerCharacter pc) {
        ArrayList<String> returnList = new ArrayList<String>();
        StringTokenizer aTok = new StringTokenizer((String)pc.getMiscList().get(2), "\r\n", false);
        while (aTok.hasMoreTokens()) {
            returnList.add(aTok.nextToken());
        }
        return returnList;
    }
}

