/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.VarToken;
import plugin.charactersheet.gui.CharacterPanel;

public class PerDayPane
extends JPanel {
    private PlayerCharacter pc;
    private String var = "";
    private String var2 = "";
    private ArrayList checkList = new ArrayList();
    private Properties pcProperties;
    private boolean updateProperties = false;
    private JPanel checkPane;
    private JCheckBox jCheckBox2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JLabel numDayLabel;
    private JLabel summaryLabel;
    private JLabel title;

    public PerDayPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jCheckBox2 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.summaryLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.numDayLabel = new JLabel();
        this.checkPane = new JPanel();
        this.jCheckBox2.setText("jCheckBox2");
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 14));
        this.title.setText(" ");
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel5.setLayout(new FlowLayout(1, 1, 0));
        this.summaryLabel.setFont(new Font("Dialog", 0, 10));
        this.summaryLabel.setText(" ");
        this.jPanel5.add(this.summaryLabel);
        this.jPanel3.add(this.jPanel5);
        this.jPanel6.setLayout(new FlowLayout(1, 1, 0));
        this.numDayLabel.setFont(new Font("Dialog", 0, 10));
        this.jPanel6.add(this.numDayLabel);
        this.jPanel3.add(this.jPanel6);
        this.jPanel2.add(this.jPanel3);
        this.checkPane.setLayout(new BoxLayout(this.checkPane, 1));
        this.jPanel2.add(this.checkPane);
        this.add(this.jPanel2);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel2.setBackground(CharacterPanel.border);
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel3.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
        this.checkPane.setBackground(CharacterPanel.border);
        this.checkPane.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter pc, Properties pcProperties, String var, String var2, String title, String summary) {
        this.pc = pc;
        this.pcProperties = pcProperties;
        this.var = var;
        this.var2 = var2;
        this.title.setText(title);
        this.summaryLabel.setText(summary);
    }

    public void setPc(PlayerCharacter pc, Properties pcProperties, String var, String title, String summary) {
        this.setPc(pc, pcProperties, var, "", title, summary);
    }

    public void refresh() {
        int numDay = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)this.var, (boolean)false);
        if (numDay > 0) {
            this.setVisible(true);
            if (!this.var2.equals("")) {
                int var2text = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)this.var2, (boolean)false);
                this.numDayLabel.setText("(" + var2text + ")");
            } else {
                this.numDayLabel.setText("(" + numDay + ")");
            }
            this.addCheckBoxes(numDay);
        } else {
            this.setVisible(false);
        }
        this.updatePane();
    }

    private void addCheckBoxes(int numDay) {
        if (this.checkList.size() != numDay) {
            this.checkList.clear();
            this.checkPane.removeAll();
            JPanel panel = new JPanel();
            for (int i = 0; i < numDay; ++i) {
                if (i % 25 == 0) {
                    panel = new JPanel();
                    panel.setLayout(new FlowLayout(0, 0, 1));
                    panel.setBackground(CharacterPanel.white);
                    this.checkPane.add(panel);
                }
                if (i % 5 == 0) {
                    JLabel bufLabel = new JLabel();
                    bufLabel.setFont(new Font("Dialog", 0, 10));
                    bufLabel.setText(" ");
                    panel.add(bufLabel);
                }
                JCheckBox checkBox = new JCheckBox();
                checkBox.setBackground(CharacterPanel.white);
                checkBox.setBorder(null);
                this.checkList.add(checkBox);
                panel.add(checkBox);
                checkBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        PerDayPane.this.pc.setDirty(true);
                        PerDayPane.this.updateProperties();
                    }
                });
            }
        }
    }

    public void updateProperties() {
        if (this.updateProperties) {
            int counter = 0;
            for (int i = 0; i < this.checkList.size(); ++i) {
                JCheckBox checkBox = (JCheckBox)this.checkList.get(i);
                if (!checkBox.isSelected()) continue;
                ++counter;
            }
            this.pcProperties.put("cs.PerDayPane." + this.getPropTitle(), counter + "");
        }
    }

    public void updatePane() {
        try {
            int counter = Integer.parseInt((String)this.pcProperties.get("cs.PerDayPane." + this.getPropTitle()));
            for (int i = 0; i < this.checkList.size(); ++i) {
                JCheckBox checkBox = (JCheckBox)this.checkList.get(i);
                if (counter > 0) {
                    checkBox.setSelected(true);
                    --counter;
                    continue;
                }
                checkBox.setSelected(false);
            }
            this.updateProperties = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String getPropTitle() {
        String titleStr = this.title.getText();
        return titleStr.replaceAll(" ", "");
    }
}

