/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.PreferencesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import pcgen.core.SettingsHandler;
import plugin.charactersheet.CharacterSheetModel;

public class PreferencesDisplayPanel
extends PreferencesPanel {
    private CharacterSheetModel model;
    private final Color blue = new Color(153, 153, 187);
    private final Color lightBlue = new Color(187, 187, 238);
    private final Color green = new Color(153, 187, 153);
    private final Color lightGreen = new Color(68, 204, 68);
    private final Color red = new Color(187, 153, 153);
    private final Color lightRed = new Color(204, 0, 0);
    private final Color yellow = new Color(187, 187, 153);
    private final Color lightYellow = new Color(204, 204, 68);
    private final Color grey = new Color(153, 153, 153);
    private final Color lightGrey = new Color(255, 255, 255);
    private JComboBox cbColor;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;

    public PreferencesDisplayPanel(CharacterSheetModel model) {
        this.initComponents();
        this.initCb();
        this.initPreferences();
        this.model = model;
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.cbColor = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jSeparator1.setOrientation(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.ipady = 260;
        gridBagConstraints.insets = new Insets(8, 17, 0, 0);
        this.add(this.jSeparator1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Dialog", 1, 18));
        this.jLabel2.setText("Display Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add(this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 400;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add(this.jSeparator2, gridBagConstraints);
        this.jLabel3.setText("Sheet Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add(this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add(this.cbColor, gridBagConstraints);
    }

    private void initCb() {
        this.cbColor.setRenderer(new ColorRenderer());
        Vector<ColorContainer> data = new Vector<ColorContainer>();
        data.add(new ColorContainer(0));
        data.add(new ColorContainer(1));
        data.add(new ColorContainer(2));
        data.add(new ColorContainer(3));
        data.add(new ColorContainer(4));
        data.add(new ColorContainer(5));
        data.add(new ColorContainer(6));
        data.add(new ColorContainer(7));
        data.add(new ColorContainer(8));
        data.add(new ColorContainer(9));
        this.cbColor.setModel(new DefaultComboBoxModel(data));
    }

    public void setColor(int value) {
        this.cbColor.setSelectedIndex(value);
    }

    public int getColor() {
        Object o = this.cbColor.getSelectedItem();
        ColorContainer value = new ColorContainer(0);
        if (o instanceof ColorContainer) {
            value = (ColorContainer)o;
        }
        return value.intValue();
    }

    public void applyPreferences() {
        SettingsHandler.setGMGenOption((String)"CharacterSheet.color", (int)this.getColor());
        this.model.applyPrefs();
    }

    public void initPreferences() {
        this.setColor(SettingsHandler.getGMGenOption((String)"CharacterSheet.color", (int)0));
    }

    public String toString() {
        return "Display";
    }

    private class ColorContainer {
        private Color color;
        private int constant;

        public ColorContainer(int constant) {
            this.color = this.getColorFromConstant(constant);
            this.constant = constant;
        }

        public int intValue() {
            return this.constant;
        }

        public String toString() {
            switch (this.constant) {
                case 0: {
                    return "Blue";
                }
                case 1: {
                    return "Light Blue";
                }
                case 2: {
                    return "Green";
                }
                case 3: {
                    return "Light Green";
                }
                case 4: {
                    return "Red";
                }
                case 5: {
                    return "Light Red";
                }
                case 6: {
                    return "Yellow";
                }
                case 7: {
                    return "Light Yellow";
                }
                case 8: {
                    return "Grey";
                }
                case 9: {
                    return "Light Grey";
                }
            }
            return "Blue";
        }

        public Color getColor() {
            return this.color;
        }

        private Color getColorFromConstant(int constant) {
            switch (constant) {
                case 0: {
                    return PreferencesDisplayPanel.this.blue;
                }
                case 1: {
                    return PreferencesDisplayPanel.this.lightBlue;
                }
                case 2: {
                    return PreferencesDisplayPanel.this.green;
                }
                case 3: {
                    return PreferencesDisplayPanel.this.lightGreen;
                }
                case 4: {
                    return PreferencesDisplayPanel.this.red;
                }
                case 5: {
                    return PreferencesDisplayPanel.this.lightRed;
                }
                case 6: {
                    return PreferencesDisplayPanel.this.yellow;
                }
                case 7: {
                    return PreferencesDisplayPanel.this.lightYellow;
                }
                case 8: {
                    return PreferencesDisplayPanel.this.grey;
                }
                case 9: {
                    return PreferencesDisplayPanel.this.lightGrey;
                }
            }
            return PreferencesDisplayPanel.this.blue;
        }
    }

    private class ColorRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel();
            JLabel label = new JLabel();
            ColorContainer colorContainer = value instanceof ColorContainer ? (ColorContainer)value : new ColorContainer(0);
            panel.setBackground(colorContainer.getColor());
            label.setText(colorContainer.toString());
            panel.add(label);
            return panel;
        }
    }

    private class ColorEditor
    extends BasicComboBoxEditor {
        private ColorEditor() {
        }

        public Component getEditorComponent() {
            JPanel panel = new JPanel();
            JLabel label = new JLabel();
            ColorContainer colorContainer = this.getItem() instanceof ColorContainer ? (ColorContainer)this.getItem() : new ColorContainer(0);
            panel.setBackground(colorContainer.getColor());
            label.setText(colorContainer.toString());
            panel.add(label);
            return panel;
        }
    }
}

