/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.VarToken;
import plugin.charactersheet.gui.CharacterPanel;

public class RagePane
extends JPanel {
    private PlayerCharacter pc;
    private ArrayList checkList = new ArrayList();
    private static final String rageText1 = "The Barbarian temporarily gains +4 to Strength, +4 to Constitution, and a +2 morale bonus on Will saves, but suffers a -2 penalty to AC.";
    private static final String rageText2 = "The Barbarian temporarily gains +6 to Strength, +6 to Constitution, and a +3 morale bonus on Will saves, but suffers a -2 penalty to AC.";
    private static final String rageText3 = "The Barbarian temporarily gains +8 to Strength, +8 to Constitution, and a +4 morale bonus on Will saves, but suffers a -2 penalty to AC.";
    private static final String rageTextLength = "A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. ";
    private static final String rageTextFatigue = "At the end of the rage, the barbarian is fatigued (-2 to Strength, -2 to Dexterity, can't charge or run) for the duration of that encounter";
    private static final String rageTextFrequency = "The barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.";
    private Properties pcProperties;
    private boolean updateProperties = false;
    private JPanel checkPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextArea rageText;

    public RagePane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.checkPanel = new JPanel();
        this.rageText = new JTextArea();
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setText("BARBARIAN RAGE");
        this.jPanel1.add(this.jLabel1);
        this.add(this.jPanel1);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.jPanel2.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel2.setFont(new Font("Dialog", 0, 10));
        this.jLabel2.setText("Uses Per Day");
        this.jPanel2.add(this.jLabel2);
        this.jPanel3.add(this.jPanel2);
        this.checkPanel.setLayout(new FlowLayout(1, 0, 1));
        this.jPanel3.add(this.checkPanel);
        this.add(this.jPanel3);
        this.rageText.setFont(new Font("Dialog", 0, 10));
        this.rageText.setLineWrap(true);
        this.rageText.setWrapStyleWord(true);
        this.add(this.rageText);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel2.setBackground(CharacterPanel.header);
        this.jPanel2.setBorder(new LineBorder(CharacterPanel.header));
        this.checkPanel.setBackground(CharacterPanel.white);
        this.checkPanel.setBorder(new LineBorder(CharacterPanel.header));
        this.rageText.setBorder(new LineBorder(CharacterPanel.header));
    }

    public void setPc(PlayerCharacter pc, Properties pcProperties) {
        this.pc = pc;
        this.pcProperties = pcProperties;
    }

    public void refresh() {
        int numDay = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)"RageTimes", (boolean)false);
        if (numDay > 0) {
            this.setVisible(true);
            int greaterRage = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)"GreaterRage", (boolean)false);
            int tirelessRage = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)"TirelessRage", (boolean)false);
            int mightyRage = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)"MightyRage", (boolean)false);
            if (mightyRage == 1) {
                this.rageText.setText("The Barbarian temporarily gains +8 to Strength, +8 to Constitution, and a +4 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. The barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            } else if (tirelessRage == 1) {
                this.rageText.setText("The Barbarian temporarily gains +6 to Strength, +6 to Constitution, and a +3 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. The barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            } else if (greaterRage == 1) {
                this.rageText.setText("The Barbarian temporarily gains +6 to Strength, +6 to Constitution, and a +3 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. At the end of the rage, the barbarian is fatigued (-2 to Strength, -2 to Dexterity, can't charge or run) for the duration of that encounterThe barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            } else {
                this.rageText.setText("The Barbarian temporarily gains +4 to Strength, +4 to Constitution, and a +2 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. At the end of the rage, the barbarian is fatigued (-2 to Strength, -2 to Dexterity, can't charge or run) for the duration of that encounterThe barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            }
            this.addCheckBoxes(numDay);
        } else {
            this.setVisible(false);
        }
        this.updatePane();
    }

    private void addCheckBoxes(int numDay) {
        if (this.checkList.size() != numDay) {
            this.checkList.clear();
            for (int i = 0; i < numDay; ++i) {
                if (i % 5 == 0 && i != 0) {
                    JLabel bufLabel = new JLabel();
                    bufLabel.setFont(new Font("Dialog", 0, 10));
                    bufLabel.setText(" ");
                    this.checkPanel.add(bufLabel);
                }
                JCheckBox checkBox = new JCheckBox();
                checkBox.setBackground(CharacterPanel.white);
                checkBox.setBorder(null);
                this.checkList.add(checkBox);
                this.checkPanel.add(checkBox);
                checkBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        RagePane.this.pc.setDirty(true);
                        RagePane.this.updateProperties();
                    }
                });
            }
        }
    }

    public void updateProperties() {
        if (this.updateProperties) {
            int counter = 0;
            for (int i = 0; i < this.checkList.size(); ++i) {
                JCheckBox checkBox = (JCheckBox)this.checkList.get(i);
                if (!checkBox.isSelected()) continue;
                ++counter;
            }
            this.pcProperties.put("cs.RagePane", counter + "");
        }
    }

    public void updatePane() {
        try {
            int counter = Integer.parseInt((String)this.pcProperties.get("cs.RagePane"));
            for (int i = 0; i < this.checkList.size(); ++i) {
                JCheckBox checkBox = (JCheckBox)this.checkList.get(i);
                if (counter > 0) {
                    checkBox.setSelected(true);
                    --counter;
                    continue;
                }
                checkBox.setSelected(false);
            }
            this.updateProperties = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

