/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import plugin.charactersheet.gui.CharacterPanel;

public class ShortListPane
extends JPanel {
    private List list = new ArrayList();
    private JPanel jPanel1;
    private JPanel listPane;
    private JLabel title;

    public ShortListPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.listPane = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 14));
        this.title.setText(" ");
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.listPane.setLayout(new BoxLayout(this.listPane, 1));
        this.add(this.listPane);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.listPane.setBackground(CharacterPanel.white);
        this.listPane.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setList(String title, List list) {
        this.list = list;
        this.title.setText(title);
        this.setVisible(false);
        this.refresh();
    }

    public void refresh() {
        if (this.list.size() > 0) {
            this.setVisible(true);
            this.listPane.removeAll();
            for (int i = 0; i < this.list.size(); ++i) {
                Color color = i % 2 == 0 ? CharacterPanel.bodyLight : CharacterPanel.bodyMedLight;
                this.addLine(this.list.get(i).toString(), color, i);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void addLine(String text, Color color, int gridY) {
        JTextArea listDisplay = new JTextArea();
        listDisplay.setLineWrap(true);
        listDisplay.setWrapStyleWord(true);
        listDisplay.setBackground(color);
        listDisplay.setFont(new Font("Dialog", 0, 10));
        listDisplay.setText(text);
        this.listPane.add(listDisplay);
    }
}

