/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import plugin.charactersheet.gui.CharacterPanel;
import plugin.charactersheet.gui.WeaponPane;

public class WeaponListPane
extends JPanel {
    private PlayerCharacter pc;
    private ArrayList weaponList = new ArrayList();
    private int weaponTotal = 0;
    private int serial = 0;
    private boolean firstTime = true;

    public WeaponListPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public void setColor() {
        this.setLocalColor();
        for (int i = 0; i < this.weaponList.size(); ++i) {
            WeaponPane weapPane = (WeaponPane)this.weaponList.get(i);
            weapPane.setColor();
        }
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
    }

    public void setPc(PlayerCharacter pc) {
        this.pc = pc;
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            List weaps = this.pc.getEquipmentOfTypeInOutputOrder("WEAPON", 3);
            if (weaps.size() != this.weaponTotal || this.firstTime) {
                this.addEqPanes(weaps);
                this.firstTime = false;
            } else {
                for (int i = 0; i < this.weaponList.size(); ++i) {
                    WeaponPane weapPane = (WeaponPane)this.weaponList.get(i);
                    weapPane.refresh();
                }
            }
            this.serial = this.pc.getSerial();
        }
    }

    private void addEqPanes(List weapons) {
        for (int i = 0; i < this.weaponList.size(); ++i) {
            this.remove((Component)this.weaponList.get(i));
        }
        this.weaponList.clear();
        this.weaponTotal = weapons.size();
        int gridBag = 1;
        for (int i = 0; i < weapons.size(); ++i) {
            WeaponPane weaponPane = new WeaponPane();
            weaponPane.setWeapon(this.pc, (Equipment)weapons.get(i));
            this.add(weaponPane);
            this.weaponList.add(weaponPane);
            weaponPane.refresh();
            ++gridBag;
        }
    }
}

