/*
 * Decompiled with CFR 0.152.
 */
package gmgen;

import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesDialog;
import gmgen.gui.PreferencesRootTreeNode;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.PluginLoader;
import gmgen.pluginmgr.messages.ClipboardMessage;
import gmgen.pluginmgr.messages.FetchOpenPCGRequestMessage;
import gmgen.pluginmgr.messages.FileOpenMessage;
import gmgen.pluginmgr.messages.LoadMessage;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.SaveMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import gmgen.util.LogUtilities;
import gmgen.util.MiscUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.EventObject;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public class GMGenSystem
extends JFrame
implements ChangeListener,
MenuListener,
ActionListener,
GMBComponent {
    public static GMGenSystem inst;
    public static final int WIDTH = 700;
    public static final int HEIGHT = 500;
    public static boolean MAC_OS_X;
    public JMenuItem copyEditItem;
    public JMenuItem cutEditItem;
    public JMenuItem newFileItem;
    public JMenuItem openFileItem;
    public JMenuItem pasteEditItem;
    public JMenuItem preferencesEditItem;
    public JMenuItem saveFileItem;
    private GMGenSystemView theView;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JMenu toolsMenu;
    private JMenuBar systemMenu;
    private JMenuItem exitFileItem;
    private JMenuItem versionToolsItem;
    private JSeparator editSeparator1;
    private JSeparator fileSeparator1;
    private JSeparator fileSeparator2;
    private JSeparator toolsSeparator1;
    private PreferencesRootTreeNode rootNode = new PreferencesRootTreeNode();
    static /* synthetic */ Class class$gmgen$GMGenSystem;

    public GMGenSystem() {
        super("GMGen System");
        new Renderer().start();
    }

    private void initialize() {
        if (MAC_OS_X) {
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "false");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "GMGen");
            this.macOSXRegistration();
        }
        inst = this;
        this.initLogger();
        this.createMenuBar();
        this.theView = new GMGenSystemView();
        GMBus.addToBus(this);
        PluginLoader ploader = PluginLoader.inst();
        ploader.startSystemPlugins("GMGen");
        this.initComponents();
        this.initSettings();
        GMBus.send(new FetchOpenPCGRequestMessage(this));
        GMBus.send(new StateChangedMessage(this, this.editMenu));
        inst.setVisible(true);
    }

    public static String getBuild() {
        return "03.03.99.01.00";
    }

    public static String getVersion() {
        return MiscUtilities.buildToVersion(GMGenSystem.getBuild());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.openFileItem) {
            GMBus.send(new FileOpenMessage(this));
        } else if (e.getSource() == this.exitFileItem) {
            GMBus.send(new WindowClosedMessage(this));
        } else if (e.getSource() == this.newFileItem) {
            GMBus.send(new LoadMessage(this));
        } else if (e.getSource() == this.saveFileItem) {
            GMBus.send(new SaveMessage(this));
        } else if (e.getSource() == this.cutEditItem) {
            GMBus.send(new ClipboardMessage(this, 0));
        } else if (e.getSource() == this.copyEditItem) {
            GMBus.send(new ClipboardMessage(this, 1));
        } else if (e.getSource() == this.pasteEditItem) {
            GMBus.send(new ClipboardMessage(this, 2));
        }
    }

    public void clearEditMenu() {
        this.editMenu.removeAll();
        if (!MAC_OS_X) {
            this.editMenu.add(this.editSeparator1);
            this.preferencesEditItem.setText("Preferences");
            this.editMenu.add(this.preferencesEditItem);
            this.preferencesEditItem.setEnabled(true);
            ActionListener[] listenerArray = this.preferencesEditItem.getActionListeners();
            for (int i = 0; i < listenerArray.length; ++i) {
                this.preferencesEditItem.removeActionListener(listenerArray[i]);
            }
            this.preferencesEditItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GMGenSystem.this.mPreferencesActionPerformed(evt);
                }
            });
        }
    }

    public void exitFormMac() {
        this.setVisible(false);
    }

    public void handleFileMenu() {
    }

    public void handleMessage(GMBMessage message) {
        if (message instanceof TabAddMessage) {
            TabAddMessage tmessage = (TabAddMessage)message;
            if (tmessage.getSystem().equals("GMGen")) {
                Logging.debugPrint("Creating Tab " + GMGenSystemView.getTabPane().getTabCount());
                this.theView.insertPane(tmessage.getName(), tmessage.getPane(), GMGenSystemView.getTabPane().getTabCount());
            }
        } else if (message instanceof PreferencesPanelAddMessage) {
            PreferencesPanelAddMessage pmessage = (PreferencesPanelAddMessage)message;
            Logging.debugPrint("Creating Preferences Panel");
            this.rootNode.addPanel(pmessage.getName(), pmessage.getPane());
        } else if (message instanceof ToolMenuItemAddMessage) {
            ToolMenuItemAddMessage mmessage = (ToolMenuItemAddMessage)message;
            this.toolsMenu.add(mmessage.getMenuItem());
        } else if (message instanceof WindowClosedMessage) {
            this.setCloseSettings();
        } else if (message instanceof PCLoadedMessage) {
            // empty if block
        }
    }

    public void handleToolsMenu() {
    }

    public void mPreferencesActionPerformedMac() {
        PreferencesDialog dialog = new PreferencesDialog((Frame)this, true, this.rootNode);
        dialog.setVisible(true);
    }

    public void macOSXRegistration() {
        if (MAC_OS_X) {
            try {
                Class<?> osxAdapter = Class.forName("gmgen.util.OSXAdapter");
                Class[] defArgs = new Class[]{class$gmgen$GMGenSystem == null ? (class$gmgen$GMGenSystem = GMGenSystem.class$("gmgen.GMGenSystem")) : class$gmgen$GMGenSystem};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                if (prefsEnableMethod != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        if (e.getSource() == this.fileMenu) {
            this.handleFileMenu();
        } else if (e.getSource() == this.toolsMenu) {
            this.handleToolsMenu();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.stateUpdate(e);
    }

    public void stateUpdate(EventObject e) {
        this.newFileItem.setEnabled(false);
        this.openFileItem.setEnabled(false);
        this.saveFileItem.setEnabled(false);
        this.clearEditMenu();
        GMBus.send(new StateChangedMessage(this, this.editMenu));
    }

    private void setCloseSettings() {
        SettingsHandler.setGMGenOption("WindowX", this.getX());
        SettingsHandler.setGMGenOption("WindowY", this.getY());
        SettingsHandler.setGMGenOption("WindowWidth", this.getSize().width);
        SettingsHandler.setGMGenOption("WindowHeight", this.getSize().height);
        if ((this.getExtendedState() & 6) != 0) {
            SettingsHandler.setGMGenOption("WindowState", 6);
        } else if ((this.getExtendedState() & 2) != 0) {
            SettingsHandler.setGMGenOption("WindowState", 2);
        } else if ((this.getExtendedState() & 4) != 0) {
            SettingsHandler.setGMGenOption("WindowState", 4);
        } else {
            SettingsHandler.setGMGenOption("WindowState", 0);
        }
    }

    private void setTabbedPanes() {
        try {
            GMGenSystemView.getTabPane().setSelectedIndex(0);
            this.theView.showPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTabsDisabled() {
        for (int i = 1; i < GMGenSystemView.getTabPane().getTabCount(); ++i) {
            GMGenSystemView.getTabPane().setSelectedIndex(i);
            GMGenSystemView.getTabPane().setEnabled(false);
        }
        this.toolsMenu.setEnabled(false);
        GMGenSystemView.getTabPane().setSelectedIndex(0);
    }

    private void setTabsEnabled() {
        for (int i = 1; i < GMGenSystemView.getTabPane().getTabCount(); ++i) {
            GMGenSystemView.getTabPane().setSelectedIndex(i);
            GMGenSystemView.getTabPane().setEnabled(true);
        }
        this.toolsMenu.setEnabled(true);
        GMGenSystemView.getTabPane().setSelectedIndex(0);
    }

    private void createMenuBar() {
        this.systemMenu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newFileItem = new JMenuItem();
        this.openFileItem = new JMenuItem();
        this.fileSeparator1 = new JSeparator();
        this.saveFileItem = new JMenuItem();
        this.fileSeparator2 = new JSeparator();
        this.exitFileItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutEditItem = new JMenuItem();
        this.copyEditItem = new JMenuItem();
        this.pasteEditItem = new JMenuItem();
        this.editSeparator1 = new JSeparator();
        this.preferencesEditItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.toolsSeparator1 = new JSeparator();
        this.versionToolsItem = new JMenuItem();
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.addMenuListener(this);
        this.newFileItem.setMnemonic('N');
        this.newFileItem.setText("New");
        this.newFileItem.addActionListener(this);
        this.fileMenu.add(this.newFileItem);
        this.openFileItem.setMnemonic('O');
        this.openFileItem.setText("Open");
        this.fileMenu.add(this.openFileItem);
        this.openFileItem.addActionListener(this);
        this.fileMenu.add(this.fileSeparator1);
        this.saveFileItem.setMnemonic('S');
        this.saveFileItem.setText("Save");
        this.fileMenu.add(this.saveFileItem);
        this.saveFileItem.addActionListener(this);
        if (!MAC_OS_X) {
            this.fileMenu.add(this.fileSeparator2);
            this.exitFileItem.setMnemonic('x');
            this.exitFileItem.setText("Exit");
            this.fileMenu.add(this.exitFileItem);
            this.exitFileItem.addActionListener(this);
        }
        this.systemMenu.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.setMnemonic('E');
        this.editMenu.addMenuListener(this);
        this.cutEditItem.setText("Cut");
        this.editMenu.add(this.cutEditItem);
        this.copyEditItem.setText("Copy");
        this.editMenu.add(this.copyEditItem);
        this.pasteEditItem.setText("Paste");
        this.editMenu.add(this.pasteEditItem);
        if (!MAC_OS_X) {
            this.editMenu.add(this.editSeparator1);
            this.preferencesEditItem.setText("Preferences");
            this.editMenu.add(this.preferencesEditItem);
            this.preferencesEditItem.setEnabled(true);
            ActionListener[] listenerArray = this.preferencesEditItem.getActionListeners();
            for (int i = 0; i < listenerArray.length; ++i) {
                this.preferencesEditItem.removeActionListener(listenerArray[i]);
            }
            this.preferencesEditItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GMGenSystem.this.mPreferencesActionPerformed(evt);
                }
            });
        }
        this.systemMenu.add(this.editMenu);
        this.toolsMenu.setText("Tools");
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.addMenuListener(this);
        this.versionToolsItem.setMnemonic('G');
        this.versionToolsItem.setText("Get Newest Version");
        this.toolsMenu.add(this.versionToolsItem);
        this.toolsMenu.add(this.toolsSeparator1);
        this.systemMenu.add(this.toolsMenu);
        this.setJMenuBar(this.systemMenu);
        this.openFileItem.setEnabled(true);
        this.saveFileItem.setEnabled(false);
        this.newFileItem.setEnabled(false);
        this.cutEditItem.setEnabled(false);
        this.copyEditItem.setEnabled(false);
        this.pasteEditItem.setEnabled(false);
        this.preferencesEditItem.setEnabled(true);
        this.versionToolsItem.setEnabled(false);
        this.pack();
    }

    private void exit() {
        GMBus.send(new WindowClosedMessage(this));
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    private void handleOpenFile() {
        File defaultFile = SettingsHandler.getPcgPath();
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(defaultFile);
        String[] pcgs = new String[]{"pcg", "pcp"};
        SimpleFileFilter ff = new SimpleFileFilter(pcgs, "PCGen File");
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        chooser.setMultiSelectionEnabled(true);
        Cursor saveCursor = MiscUtilities.setBusyCursor(this.theView);
        int option = chooser.showOpenDialog(this.theView);
        if (option == 0) {
            File[] pcFiles = chooser.getSelectedFiles();
            for (int i = 0; i < pcFiles.length; ++i) {
                Logging.debugPrint("Opening file " + pcFiles[i].toString());
                SettingsHandler.setPcgPath(pcFiles[i].getParentFile());
                if (!pcFiles[i].toString().endsWith(".pcg") && !pcFiles[i].toString().endsWith(".pcp")) continue;
                GMBus.send(new OpenPCGRequestMessage(this, pcFiles[i], false));
            }
            this.setTabsEnabled();
        }
        MiscUtilities.setCursor(this.theView, saveCursor);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTabbedPanes();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GMGenSystem.this.exitForm(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                GMGenSystem.this.stateUpdate(e);
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
        GMGenSystemView.getTabPane().addChangeListener(this);
        this.getContentPane().add((Component)this.theView, "Center");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage(this.getClass().getResource("/pcgen/gui/resource/gmgen_icon.png"));
        this.setIconImage(img);
    }

    private void initLogger() {
        LogUtilities.inst().setLoggingOn(SettingsHandler.getGMGenOption("Logging.On", false));
    }

    private boolean initPcgenLocation() {
        return true;
    }

    private void initSettings() {
        int iWinX = SettingsHandler.getGMGenOption("WindowX", 0);
        int iWinY = SettingsHandler.getGMGenOption("WindowY", 0);
        this.setLocation(iWinX, iWinY);
        int iWinWidth = SettingsHandler.getGMGenOption("WindowWidth", 750);
        int iWinHeight = SettingsHandler.getGMGenOption("WindowHeight", 580);
        this.setSize(iWinWidth, iWinHeight);
        int windowState = SettingsHandler.getGMGenOption("WindowState", 0);
        if (windowState != 0) {
            this.setExtendedState(windowState);
        }
    }

    private void mPreferencesActionPerformed(ActionEvent evt) {
        PreferencesDialog dialog = new PreferencesDialog((Frame)this, true, this.rootNode);
        dialog.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAC_OS_X = System.getProperty("os.name").equals("Mac OS X");
    }

    private class Renderer
    extends Thread {
        private Renderer() {
        }

        public void run() {
            GMGenSystem.this.initialize();
        }
    }
}

