/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;

public class GridBoxLayout
extends GridLayout
implements Serializable {
    public GridBoxLayout() {
        this(1, 0, 0, 0);
    }

    public GridBoxLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public GridBoxLayout(int rows, int cols, int hgap, int vgap) throws IllegalArgumentException {
        super(rows, cols, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            int c;
            Insets insets = parent.getInsets();
            int nComponents = parent.getComponentCount();
            int nRows = this.getRows();
            int nCols = this.getColumns();
            if (nRows > 0) {
                nCols = (nComponents + nRows - 1) / nRows;
            } else {
                nRows = (nComponents + nCols - 1) / nCols;
            }
            int[] widths = new int[nCols];
            int[] heights = new int[nRows];
            for (c = 0; c < nCols; ++c) {
                widths[c] = Integer.MIN_VALUE;
            }
            for (r = 0; r < nRows; ++r) {
                heights[r] = Integer.MIN_VALUE;
            }
            c = 0;
            r = 0;
            for (int i = 0; i < nComponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if (widths[c] < d.width) {
                    widths[c] = d.width;
                }
                if (heights[r] < d.height) {
                    heights[r] = d.height;
                }
                if (++c < nCols) continue;
                c = 0;
                ++r;
            }
            int w = 0;
            int h = 0;
            for (c = 0; c < nCols; ++c) {
                w += widths[c];
            }
            for (r = 0; r < nRows; ++r) {
                h += heights[r];
            }
            return new Dimension(insets.left + insets.right + w + (nCols - 1) * this.getHgap(), insets.top + insets.bottom + h + (nRows - 1) * this.getVgap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            int c;
            Insets insets = parent.getInsets();
            int nComponents = parent.getComponentCount();
            int nRows = this.getRows();
            int nCols = this.getColumns();
            if (nRows > 0) {
                nCols = (nComponents + nRows - 1) / nRows;
            } else {
                nRows = (nComponents + nCols - 1) / nCols;
            }
            int[] widths = new int[nCols];
            int[] heights = new int[nRows];
            for (c = 0; c < nCols; ++c) {
                widths[c] = Integer.MIN_VALUE;
            }
            for (r = 0; r < nRows; ++r) {
                heights[r] = Integer.MIN_VALUE;
            }
            c = 0;
            r = 0;
            for (int i = 0; i < nComponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getMinimumSize();
                if (widths[c] < d.width) {
                    widths[c] = d.width;
                }
                if (heights[r] < d.height) {
                    heights[r] = d.height;
                }
                if (++c < nCols) continue;
                c = 0;
                ++r;
            }
            int w = 0;
            int h = 0;
            for (c = 0; c < nCols; ++c) {
                w += widths[c];
            }
            for (r = 0; r < nRows; ++r) {
                h += heights[r];
            }
            return new Dimension(insets.left + insets.right + w + (nCols - 1) * this.getHgap(), insets.top + insets.bottom + h + (nRows - 1) * this.getVgap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            int c;
            Insets insets = parent.getInsets();
            int nComponents = parent.getComponentCount();
            int nRows = this.getRows();
            int nCols = this.getColumns();
            if (nComponents == 0) {
                return;
            }
            if (nRows > 0) {
                nCols = (nComponents + nRows - 1) / nRows;
            } else {
                nRows = (nComponents + nCols - 1) / nCols;
            }
            int[] widths = new int[nCols];
            int[] heights = new int[nRows];
            for (c = 0; c < nCols; ++c) {
                widths[c] = Integer.MIN_VALUE;
            }
            for (r = 0; r < nRows; ++r) {
                heights[r] = Integer.MIN_VALUE;
            }
            c = 0;
            r = 0;
            for (int i = 0; i < nComponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if (widths[c] < d.width) {
                    widths[c] = d.width;
                }
                if (heights[r] < d.height) {
                    heights[r] = d.height;
                }
                if (++c < nCols) continue;
                c = 0;
                ++r;
            }
            int w = 0;
            int h = 0;
            for (c = 0; c < nCols; ++c) {
                w += widths[c];
            }
            for (r = 0; r < nRows; ++r) {
                h += heights[r];
            }
            Dimension pDim = parent.getSize();
            int pWidth = pDim.width - (insets.left + insets.right) - (nCols - 1) * this.getHgap();
            int pHeight = pDim.height - (insets.top + insets.bottom) - (nRows - 1) * this.getVgap();
            float widthProportion = (float)pWidth / (float)w;
            float heightProportion = (float)pHeight / (float)h;
            for (c = 0; c < nCols; ++c) {
                widths[c] = (int)(widthProportion * (float)widths[c]);
            }
            for (r = 0; r < nRows; ++r) {
                heights[r] = (int)(heightProportion * (float)heights[r]);
            }
            int comp = 0;
            int y = insets.top;
            block10: for (r = 0; r < nRows; ++r) {
                int x = insets.left;
                for (c = 0; c < nCols; ++c) {
                    if (comp >= nComponents) break block10;
                    parent.getComponent(comp++).setBounds(x, y, widths[c], heights[r]);
                    x += widths[c] + this.getHgap();
                }
                y += heights[r] + this.getVgap();
            }
        }
    }
}

