/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class ImageFileChooserPreview
extends JComponent
implements PropertyChangeListener {
    private static final int previewWidth = 100;
    private static final int previewHeight = 100;
    private File imageFile = null;
    private ImageIcon imageThumb = null;

    public ImageFileChooserPreview(JFileChooser parent) {
        this.setPreferredSize(new Dimension(100, 100));
        parent.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.imageFile == null) {
            this.imageThumb = null;
            return;
        }
        this.imageThumb = new ImageIcon(this.imageFile.getPath());
        if (this.imageThumb.getIconHeight() < 100 && this.imageThumb.getIconWidth() < 100) {
            return;
        }
        int w = 100;
        int h = 100;
        if (this.imageThumb.getIconHeight() > this.imageThumb.getIconWidth()) {
            w = -1;
        } else {
            h = -1;
        }
        this.imageThumb = new ImageIcon(this.imageThumb.getImage().getScaledInstance(w, h, 1));
    }

    public void paintComponent(Graphics g) {
        if (this.imageThumb == null) {
            this.loadImage();
        }
        if (this.imageThumb == null) {
            return;
        }
        int x = (this.getWidth() - this.imageThumb.getIconWidth()) / 2;
        int y = (this.getHeight() - this.imageThumb.getIconHeight()) / 2;
        if (y < 0) {
            y = 0;
        }
        if (x < 5) {
            x = 5;
        }
        this.imageThumb.paintIcon(this, g, x, y);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.imageFile = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }
}

