/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.gui.LogPanel;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import pcgen.core.SettingsHandler;

public class LogWindow
extends JFrame
implements ActionListener {
    private JMenuBar menu;
    private JMenuItem clear;
    private JMenuItem close;
    private LinkedList dbgList = new LinkedList();
    private LogPanel panel;

    public LogWindow() {
        this.getContentPane().setLayout(new BorderLayout());
        this.panel = new LogPanel();
        this.getContentPane().add((Component)this.panel, "Center");
        this.menu = new JMenuBar();
        this.setJMenuBar(this.menu);
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic('E');
        this.menu.add(edit);
        this.clear = new JMenuItem("Clear", 67);
        edit.add(this.clear);
        this.clear.addActionListener(this);
        JMenu debugLevel = new JMenu("Debug Level");
        debugLevel.setMnemonic('D');
        edit.add(debugLevel);
        int currDebugLvl = SettingsHandler.getGMGenOption("Logging.DebugLevel", 2);
        ButtonGroup bgroup = new ButtonGroup();
        String[] debugStrs = new String[]{"Minimum Debug Messages", "Error Messages", "Exceptions", "Plugin Communication", "Data Structures", "Standard Messages", "Major Function Entry/Exit", "All Function Entry/Exit", "Everything"};
        for (int i = 1; i < 10; ++i) {
            boolean isSelected = currDebugLvl == i;
            JRadioButtonMenuItem dbg = new JRadioButtonMenuItem(i + " " + debugStrs[i - 1], isSelected);
            bgroup.add(dbg);
            dbg.addActionListener(this);
            this.dbgList.add(dbg);
            debugLevel.add(dbg);
        }
        int iWinX = SettingsHandler.getGMGenOption("Logging.WindowX", 0);
        int iWinY = SettingsHandler.getGMGenOption("Logging.WindowY", 0);
        int iWinWidth = SettingsHandler.getGMGenOption("Logging.WindowWidth", 440);
        int iWinHeight = SettingsHandler.getGMGenOption("Logging.WindowHeight", 230);
        this.panel.setPreferredSize(new Dimension(iWinWidth - 5, iWinHeight - 5));
        this.pack();
        this.setTitle("GMGen Log Console");
        this.setLocation(iWinX, iWinY);
        this.setSize(iWinWidth, iWinHeight);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage(this.getClass().getResource("/pcgen/gui/resource/gmgen_icon.png"));
        this.setIconImage(img);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.setVisible(false);
        } else if (e.getSource() == this.clear) {
            this.panel.clearCurrentTab();
            LogUtilities.inst().logMessage("LogWindow", "Clearing current tab");
        }
    }
}

