/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.gui.PreferencesPanel;
import gmgen.gui.PreferencesRootTreeNode;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import pcgen.core.SettingsHandler;

public class PreferencesDialog
extends JDialog {
    private JButton bApply;
    private JButton bCancel;
    private JButton bOk;
    private JPanel jPanel2;
    private JSplitPane jSplitPane1;
    private JTabbedPane prefsPane;
    private JTree prefsTree;
    private PreferencesRootTreeNode root;

    public PreferencesDialog(Frame parent, boolean modal, PreferencesRootTreeNode root) {
        super(parent, modal);
        this.root = root;
        this.initComponents();
        this.initLast();
        this.initPreferences();
    }

    public void applyPreferences() {
        ArrayList panelList = this.root.getPanelList();
        for (int i = 0; i < panelList.size(); ++i) {
            PreferencesPanel panel = (PreferencesPanel)panelList.get(i);
            panel.applyPreferences();
        }
    }

    private void PrefsTreeActionPerformed(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node;
        Object uobj;
        Object obj = this.prefsTree.getLastSelectedPathComponent();
        if (obj instanceof DefaultMutableTreeNode && (uobj = (node = (DefaultMutableTreeNode)obj).getUserObject()) instanceof PreferencesPanel) {
            this.prefsPane.removeAll();
            this.prefsPane.addTab(obj.toString(), (PreferencesPanel)uobj);
        }
    }

    private void bApplyActionPerformed(ActionEvent evt) {
        this.applyPreferences();
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.applyPreferences();
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        SettingsHandler.setGMGenOption("PreferencesDialog.PrefsDividerLocation", this.jSplitPane1.getDividerLocation());
        SettingsHandler.setGMGenOption("PreferencesDialog.PrefsWindowX", this.getX());
        SettingsHandler.setGMGenOption("PreferencesDialog.PrefsWindowY", this.getY());
        SettingsHandler.setGMGenOption("PreferencesDialog.PrefsWindowWidth", this.getSize().width);
        SettingsHandler.setGMGenOption("PreferencesDialog.PrefsWindowHeight", this.getSize().height);
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.bOk = new JButton();
        this.bCancel = new JButton();
        this.bApply = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.prefsTree = new JTree(this.root);
        this.prefsPane = new JTabbedPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PreferencesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.bOk.setText("Ok");
        this.bOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.bOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bOk);
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.bCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bCancel);
        this.bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.bCancelActionPerformed(evt);
            }
        });
        this.bApply.setText("Apply");
        this.bApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.bApplyActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.bApply);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jSplitPane1.setLeftComponent(this.prefsTree);
        this.prefsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                PreferencesDialog.this.PrefsTreeActionPerformed(evt);
            }
        });
        this.jSplitPane1.setRightComponent(this.prefsPane);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
    }

    private void initLast() {
        int iDividerLocation = SettingsHandler.getGMGenOption("PreferencesDialog.PrefsDividerLocation", 118);
        this.jSplitPane1.setDividerLocation(iDividerLocation);
        int iWinX = SettingsHandler.getGMGenOption("PreferencesDialog.PrefsWindowX", 0);
        int iWinY = SettingsHandler.getGMGenOption("PreferencesDialog.PrefsWindowY", 0);
        this.setLocation(iWinX, iWinY);
        int iWinWidth = SettingsHandler.getGMGenOption("PreferencesDialog.PrefsWindowWidth", 550);
        int iWinHeight = SettingsHandler.getGMGenOption("PreferencesDialog.PrefsWindowHeight", 385);
        this.setSize(iWinWidth, iWinHeight);
    }

    private void initPreferences() {
        ArrayList panelList = this.root.getPanelList();
        for (int i = 0; i < panelList.size(); ++i) {
            PreferencesPanel panel = (PreferencesPanel)panelList.get(i);
            panel.initPreferences();
        }
    }
}

