/*
 * Decompiled with CFR 0.152.
 */
package gmgen.io;

import gmgen.io.VectorTable;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import pcgen.util.Logging;

public class ReadXML {
    private Document d;
    private String tableName = "";
    private VectorTable vt = new VectorTable();
    private int cols = 0;
    private int rows = 0;

    public ReadXML(File file) {
        this();
        this.readxmlFile(file);
    }

    private ReadXML() {
    }

    public VectorTable getTable() {
        return this.vt;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void displayTable() {
        for (int x = 0; x < this.rows; ++x) {
            for (int y = 0; y < this.cols; ++y) {
            }
        }
    }

    public String findPercentageEntry(int value) {
        String percent = Integer.toString(value);
        for (int x = value; x <= 100 && this.vt.crossReference(percent = Integer.toString(x), "d%") == null; ++x) {
        }
        return percent;
    }

    private void readxmlFile(File table) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.d = db.parse(table);
            this.tableName = this.d.getElementsByTagName("lookuptable").item(0).getAttributes().getNamedItem("name").getNodeValue();
            this.rows = this.d.getElementsByTagName("row").getLength();
            int items = this.d.getElementsByTagName("item").getLength();
            this.cols = items / this.rows;
            this.vt.setName(table.getPath());
            int pos = 0;
            for (int x = 0; x < this.rows; ++x) {
                Vector<String> row = new Vector<String>();
                for (int y = 0; y < this.cols; ++y) {
                    row.add(this.d.getElementsByTagName("item").item(pos).getChildNodes().item(0).getNodeValue());
                    ++pos;
                }
                this.vt.add(row);
            }
        }
        catch (ParserConfigurationException e) {
            Logging.errorPrint("ParserConfigurationException!");
            Logging.errorPrint("Could not parse xml file " + table.getPath());
            Logging.errorPrint("IO", e);
        }
        catch (IOException io) {
            Logging.errorPrint("IOException!");
            Logging.errorPrint("Could not parse xml file " + table.getPath());
            Logging.errorPrint("IO", io);
        }
        catch (SAXException sax) {
            Logging.errorPrint("SAXException!");
            Logging.errorPrint("Could not parse xml file " + table.getPath());
            Logging.errorPrint("IO", sax);
        }
        catch (IllegalArgumentException iae) {
            Logging.errorPrint("IllegalArgumentException!");
            Logging.errorPrint("Could not parse xml file " + table.getPath());
            Logging.errorPrint("IO", iae);
        }
    }
}

