/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.InitHolder;
import gmgen.plugin.SystemInitiative;
import java.util.LinkedList;
import java.util.Vector;
import org.jdom.Element;
import pcgen.util.Logging;

public class Event
implements InitHolder {
    public SystemInitiative init;
    protected String effect;
    protected String name;
    protected String player;
    protected String status = "Active";
    protected boolean alert;
    protected int duration;

    public Event(String name, String player, String effect, int duration, int init, boolean alert) {
        this.setValues(name, player, this.status, effect, duration, init, alert);
    }

    public Event(String name, String player, String status, String effect, int duration, int init, boolean alert) {
        this.setValues(name, player, status, effect, duration, init, alert);
    }

    public Event() {
    }

    public Event(Element event) {
        try {
            String name = event.getAttribute("name").getValue();
            String player = event.getAttribute("player").getValue();
            String status = event.getAttribute("status").getValue();
            String effect = event.getAttribute("effect").getValue();
            int duration = event.getChild("Initiative").getAttribute("duration").getIntValue();
            int init = event.getChild("Initiative").getAttribute("initiative").getIntValue();
            boolean alert = event.getChild("Initiative").getAttribute("alert").getBooleanValue();
            this.setValues(name, player, status, effect, duration, init, alert);
        }
        catch (Exception e) {
            Logging.errorPrint("Initiative", e);
        }
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public String getEffect() {
        return this.effect;
    }

    public String getEndText() {
        return "Event " + this.getName() + " Completed or Occured";
    }

    public SystemInitiative getInitiative() {
        return this.init;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public String getPlayer() {
        return this.player;
    }

    public Vector getRowVector(LinkedList columnOrder) {
        Vector<String> rowVector = new Vector<String>();
        int columns = columnOrder.size();
        for (int j = 0; j < columns; ++j) {
            String columnName = (String)columnOrder.get(j);
            if (columnName.equals("Name")) {
                rowVector.add(this.getName());
                continue;
            }
            if (columnName.equals("Player")) {
                rowVector.add("Owner: " + this.getPlayer());
                continue;
            }
            if (columnName.equals("Status")) {
                rowVector.add(this.getStatus());
                continue;
            }
            if (columnName.equals("+")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("Init")) {
                rowVector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (columnName.equals("Dur")) {
                rowVector.add("" + this.getDuration());
                continue;
            }
            if (columnName.equals("#")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP Max")) {
                rowVector.add("");
                continue;
            }
            if (!columnName.equals("Type")) continue;
            rowVector.add("-");
        }
        return rowVector;
    }

    public Element getSaveElement() {
        Element retElement = new Element("Event");
        Element initiative = new Element("Initiative");
        initiative.setAttribute("initiative", this.init.getCurrentInitiative() + "");
        initiative.setAttribute("duration", this.getDuration() + "");
        initiative.setAttribute("alert", this.isAlert() + "");
        retElement.addContent(initiative);
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("status", this.getStatus());
        retElement.setAttribute("effect", this.getEffect());
        return retElement;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public int decDuration() {
        --this.duration;
        return this.duration;
    }

    public void editRow(LinkedList columnOrder, int colNumber, Object data) {
        String columnName = (String)columnOrder.get(colNumber);
        String strData = String.valueOf(data);
        if (columnName.equals("Name")) {
            this.setName(strData);
        } else if (columnName.equals("Player")) {
            this.setPlayer(strData);
        } else if (columnName.equals("Status")) {
            this.setStatus(strData);
        } else if (columnName.equals("Init")) {
            Integer intData = new Integer(strData);
            this.init.setCurrentInitiative(intData);
        } else if (columnName.equals("Dur")) {
            Integer intData = new Integer(strData);
            this.setDuration(intData);
        }
    }

    public void endRound() {
    }

    protected final void setValues(String name, String player, String status, String effect, int duration, int init, boolean alert) {
        this.name = name;
        this.player = player;
        this.effect = effect;
        this.duration = duration;
        this.init = new SystemInitiative(0);
        this.init.setCurrentInitiative(init);
        this.alert = alert;
        this.status = status;
    }
}

