/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderComperator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;

public class InitHolderList
extends LinkedList {
    public int getMaxInit() {
        int maxInit = 20;
        for (int i = 0; i < this.size(); ++i) {
            InitHolder c = (InitHolder)this.get(i);
            int cInit = c.getInitiative().getCurrentInitiative();
            if (cInit <= maxInit) continue;
            maxInit = cInit;
        }
        return maxInit;
    }

    public Vector getRowVector(int i, LinkedList columnOrder) {
        InitHolder iH = (InitHolder)this.get(i);
        return iH.getRowVector(columnOrder);
    }

    public String getUniqueName(String name) {
        int i = 1;
        while (!this.isUniqueName(name)) {
            name = name.replaceAll(" \\(\\d.*\\)", "") + " (" + i + ")";
            ++i;
        }
        return name;
    }

    public boolean isUniqueName(String name) {
        for (int i = 0; i < this.size(); ++i) {
            InitHolder c = (InitHolder)this.get(i);
            if (!c.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public boolean add(InitHolder user) {
        boolean result = super.add(user);
        if (result) {
            this.sort();
        }
        return result;
    }

    public void calculateNumberField() {
        int j = 1;
        for (int i = 0; i < this.size(); ++i) {
            InitHolder c = (InitHolder)this.get(i);
            if (!(c instanceof Combatant)) continue;
            Combatant cbt = (Combatant)c;
            cbt.setNumber(j);
            ++j;
        }
    }

    public void check() {
        Dice d20 = new Dice(1, 20);
        for (int i = 0; i < this.size(); ++i) {
            InitHolder c = (InitHolder)this.get(i);
            int roll = d20.roll();
            c.getInitiative().checkExtRoll(roll);
        }
        this.sort();
        this.calculateNumberField();
    }

    public boolean initValid(int init) {
        for (int i = 0; i < this.size(); ++i) {
            int cInit;
            InitHolder c = (InitHolder)this.get(i);
            if (c.getStatus().equals("Dead") || (cInit = c.getInitiative().getCurrentInitiative()) != init) continue;
            return true;
        }
        return false;
    }

    public void sort() {
        Collections.sort(this, new InitHolderComperator());
    }
}

